/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient;

import com.github.jrialland.ajpclient.Attribute;
import com.github.jrialland.ajpclient.AttributeFactory;
import com.github.jrialland.ajpclient.ForwardRequest;
import com.github.jrialland.ajpclient.Header;
import com.github.jrialland.ajpclient.impl.enums.RequestMethod;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SimpleForwardRequest
implements ForwardRequest {
    private RequestMethod method = RequestMethod.GET;
    private String protocol = "HTTP/1.1";
    private String requestUri = "/";
    private String remoteAddress = "127.0.0.1";
    private String remoteHost = "localhost";
    private String serverName = "localhost";
    boolean ssl = false;
    private int serverPort = 80;
    List<Header> headers = new ArrayList<Header>();
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private InputStream requestBody;

    @Override
    public RequestMethod getMethod() {
        return this.method;
    }

    public void setMethod(RequestMethod method) {
        this.method = method;
    }

    public void setMethod(String method) {
        this.method = RequestMethod.forMethod(method);
        if (this.method == null) {
            this.method = RequestMethod.JK_STORED;
            this.attributes.add(AttributeFactory.createStoredMethodAttribute(method));
        }
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    @Override
    public Collection<Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public InputStream getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(InputStream requestBody) {
        this.requestBody = requestBody;
    }

    public void setRequestBody(byte[] data) {
        this.requestBody = new ByteArrayInputStream(data);
        this.addHeader("Content-Length", Long.toString(data.length));
    }

    public void setRequestBody(String str) {
        this.setRequestBody(str.getBytes());
    }

    @Override
    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void addHeader(String headerName, String value) {
        this.getHeaders().add(new Header(headerName, value));
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    @Override
    public boolean isSsl() {
        return this.ssl;
    }
}

