/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient.impl;

import com.github.jrialland.ajpclient.Header;
import com.github.jrialland.ajpclient.impl.handlers.AjpMessagesHandler;
import com.github.jrialland.ajpclient.impl.handlers.AjpMessagesHandlerCallback;
import com.github.jrialland.ajpclient.impl.handlers.OutgoingFramesLogger;
import com.github.jrialland.ajpclient.pool.ChannelCallback;
import com.github.jrialland.ajpclient.pool.Channels;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.Collection;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Conversation
implements ChannelCallback,
AjpMessagesHandlerCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(Conversation.class);
    private Semaphore semaphore;
    private Channel currentChannel;

    public static Logger getLog() {
        return LOGGER;
    }

    @Override
    public void beforeUse(Channel channel) {
        channel.attr(AjpMessagesHandlerCallback.CHANNEL_ATTR).set((Object)this);
        this.semaphore = new Semaphore(0);
        this.currentChannel = channel;
    }

    protected Semaphore getSemaphore() {
        return this.semaphore;
    }

    protected Channel getCurrentChannel() {
        return this.currentChannel;
    }

    @Override
    public void beforeRelease(Channel channel) {
        channel.attr(AjpMessagesHandlerCallback.CHANNEL_ATTR).set(null);
    }

    public boolean execute(Channel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        if (Conversation.getLog().isTraceEnabled() && pipeline.get(OutgoingFramesLogger.class) == null) {
            pipeline.addLast(new ChannelHandler[]{new OutgoingFramesLogger()});
        }
        if (pipeline.get(AjpMessagesHandler.class) == null) {
            pipeline.addLast(new ChannelHandler[]{new AjpMessagesHandler()});
        }
        this.beforeUse(channel);
        boolean r = this.__doWithChannel(channel);
        this.beforeRelease(channel);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String host, int port) throws Exception {
        try (Channel channel = Channels.connect(host, port);){
            boolean bl = this.execute(channel);
            return bl;
        }
    }

    @Override
    public boolean __doWithChannel(Channel channel) throws Exception {
        throw new UnsupportedOperationException("__doWithChannel() is not implemented.");
    }

    @Override
    public void handleCPongMessage() throws Exception {
        throw new UnsupportedOperationException("handleCPongMessage() is not implemented.");
    }

    @Override
    public void handleEndResponseMessage(boolean reuse) throws Exception {
        throw new UnsupportedOperationException("handleEndResponseMessage() is not implemented.");
    }

    @Override
    public void handleGetBodyChunkMessage(int requestedLength) throws Exception {
        throw new UnsupportedOperationException("handleGetBodyChunkMessage() is not implemented.");
    }

    @Override
    public void handleSendBodyChunkMessage(ByteBuf data) throws Exception {
        throw new UnsupportedOperationException("handleSendBodyChunkMessage() is not implemented.");
    }

    @Override
    public void handleSendHeadersMessage(int statusCode, String statusMessage, Collection<Header> headers) throws Exception {
        throw new UnsupportedOperationException("handleSendHeadersMessage() is not implemented.");
    }
}

