/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient.impl;

import com.github.jrialland.ajpclient.Attribute;
import com.github.jrialland.ajpclient.Constants;
import com.github.jrialland.ajpclient.ForwardRequest;
import com.github.jrialland.ajpclient.ForwardResponse;
import com.github.jrialland.ajpclient.Header;
import com.github.jrialland.ajpclient.impl.Conversation;
import com.github.jrialland.ajpclient.impl.enums.RequestHeader;
import com.github.jrialland.ajpclient.impl.enums.RequestMethod;
import com.github.jrialland.ajpclient.pool.Buffers;
import com.github.jrialland.ajpclient.pool.ChannelCallback;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ForwardImpl
extends Conversation
implements ChannelCallback,
Constants {
    private final ForwardRequest request;
    private final ForwardResponse response;
    private boolean shouldReuse = false;
    private long timeout;
    private TimeUnit unit = null;

    public ForwardImpl(ForwardRequest request, ForwardResponse response) {
        this.request = request;
        this.response = response;
    }

    public ForwardImpl(ForwardRequest request, ForwardResponse response, long timeout, TimeUnit unit) {
        this(request, response);
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public void beforeRelease(Channel channel) {
        this.shouldReuse = false;
        super.beforeRelease(channel);
    }

    @Override
    public boolean __doWithChannel(Channel channel) throws Exception {
        this.shouldReuse = false;
        ForwardImpl.checkRequest(this.request);
        ForwardImpl.sendRequest(channel, this.request);
        if (this.unit == null) {
            ForwardImpl.getLog().debug("START ACQUIRE");
            this.getSemaphore().acquire();
            ForwardImpl.getLog().debug("END ACQUIRE");
        } else if (!this.getSemaphore().tryAcquire(this.timeout, this.unit)) {
            throw new TimeoutException("time limit exceeded");
        }
        this.response.atResponseBodyEnd(this.shouldReuse);
        return this.shouldReuse;
    }

    protected static void checkRequest(ForwardRequest request) {
        String contentLength = null;
        String transferEncoding = null;
        for (Header h : request.getHeaders()) {
            if (h.getKey().equalsIgnoreCase("Content-Length")) {
                contentLength = h.getValue();
                continue;
            }
            if (!h.getKey().equalsIgnoreCase("Transfer-Encoding")) continue;
            transferEncoding = h.getValue();
        }
        if (request.getMethod().equals((Object)RequestMethod.POST)) {
            if (contentLength == null) {
                if (transferEncoding == null || !transferEncoding.equals("chunked")) {
                    ForwardImpl.getLog().warn("POST request without a Content-Length");
                }
            } else if (!contentLength.matches("[0-9]+$")) {
                throw new IllegalArgumentException("Content-Length header is not a valid number");
            }
        }
    }

    protected static void sendRequest(Channel channel, ForwardRequest request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        DataOutputStream tmp = new DataOutputStream(baos);
        tmp.writeByte(2);
        tmp.writeByte(request.getMethod().getCode());
        ForwardImpl.writeString(request.getProtocol(), tmp);
        ForwardImpl.writeString(request.getRequestUri(), tmp);
        ForwardImpl.writeString(request.getRemoteAddress(), tmp);
        ForwardImpl.writeString(request.getRemoteHost(), tmp);
        ForwardImpl.writeString(request.getServerName(), tmp);
        tmp.writeShort(request.getServerPort());
        tmp.writeBoolean(request.isSsl());
        tmp.writeShort(request.getHeaders().size());
        for (Header header : request.getHeaders()) {
            Integer code = RequestHeader.getKeyCode(header.getKey());
            if (code == null) {
                ForwardImpl.writeString(header.getKey(), tmp);
            } else {
                tmp.writeShort(code);
            }
            ForwardImpl.writeString(header.getValue(), tmp);
        }
        for (Attribute attr : request.getAttributes()) {
            tmp.writeByte(attr.getType().getCode());
            for (String value : attr.getValue()) {
                ForwardImpl.writeString(value, tmp);
            }
        }
        tmp.write(255);
        tmp.flush();
        byte[] data = baos.toByteArray();
        if (data.length + 4 > 8192) {
            throw new IllegalArgumentException("Message size is larger than 8192 bytes.");
        }
        ByteBuf buf = Buffers.makeBuffer(4 + data.length);
        buf.writeBytes(CLIENT_MAGIC);
        buf.writeShort(data.length);
        buf.writeBytes(data);
        channel.writeAndFlush((Object)buf);
        ForwardImpl.getLog().debug("Sent : FORWARDREQUEST (2), payload size = " + data.length + " bytes");
        InputStream requestBody = request.getRequestBody();
        if (requestBody != null) {
            ForwardImpl.sendChunk(true, requestBody, 8186, channel);
        }
    }

    protected static void sendChunk(boolean firstChunk, InputStream in, int length, Channel channel) throws IOException {
        byte[] buf = new byte[8192];
        buf[0] = CLIENT_MAGIC[0];
        buf[1] = CLIENT_MAGIC[1];
        int actual = 0;
        if (in != null) {
            try {
                actual = Math.max(0, in.read(buf, 6, length));
            }
            catch (EOFException eOFException) {
            }
            catch (IndexOutOfBoundsException e) {
                throw new IOException(String.format("could not read buffer (bufLen=%s, offset=%s length=%s)", buf.length, 6, length));
            }
        }
        if (firstChunk && actual == 0) {
            return;
        }
        buf[2] = (byte)(actual + 2 >> 8);
        buf[3] = (byte)(actual + 2 & 0xFF);
        buf[4] = (byte)(actual >> 8);
        buf[5] = (byte)(actual & 0xFF);
        channel.writeAndFlush((Object)Buffers.wrap(buf, 0, actual + 6));
        ForwardImpl.getLog().debug("Sent : REQUESTBODYCHUNK (n/a), payload size = " + (actual + 2) + " bytes");
    }

    protected static void writeString(String s, DataOutputStream d) throws IOException {
        if (s == null) {
            d.writeShort(-1);
        } else {
            d.writeShort(s.length());
            d.write(s.getBytes());
            d.writeByte(0);
        }
    }

    @Override
    public void handleSendHeadersMessage(int statusCode, String statusMessage, Collection<Header> headers) throws Exception {
        this.response.setStatus(statusCode, statusMessage);
        for (Header h : headers) {
            this.response.setHeader(h.getKey(), h.getValue());
        }
        this.response.atResponseBodyBegin();
    }

    @Override
    public void handleSendBodyChunkMessage(ByteBuf data) throws Exception {
        data.readBytes(this.response.getOutputStream(), data.readableBytes());
    }

    @Override
    public void handleGetBodyChunkMessage(int requestedLength) throws Exception {
        ForwardImpl.sendChunk(false, this.request.getRequestBody(), Math.min(8186, Math.max(0, requestedLength)), this.getCurrentChannel());
    }

    @Override
    public void handleEndResponseMessage(boolean reuse) throws Exception {
        this.shouldReuse = reuse;
        this.getSemaphore().release();
    }
}

