/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient.impl.enums;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public enum RequestHeader {
    Accept("accept", 40961),
    AcceptCharset("accept-charset", 40962),
    AcceptEncoding("accept-encoding", 40963),
    AcceptLanguage("accept-language", 40964),
    Authorization("authorization", 40965),
    Connection("connection", 40966),
    ContentType("content-type", 40967),
    ContentLength("content-length", 40968),
    Cookie("cookie", 40969),
    Cookie2("cookie2", 40970),
    Host("host", 40971),
    Pragma("pragma", 40972),
    Referer("referer", 40973),
    UserAgent("user-agent", 40974);

    private final String name;
    private final int code;
    private static Map<String, Integer> codes;

    private RequestHeader(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public int getCode() {
        return this.code;
    }

    public static Integer getKeyCode(String key) {
        return codes.get(key.toLowerCase());
    }

    static {
        codes = new TreeMap<String, Integer>();
        for (RequestHeader rh : RequestHeader.values()) {
            codes.put(rh.getName(), rh.getCode());
        }
        codes = Collections.unmodifiableMap(codes);
    }
}

