/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient.impl.enums;

public enum RequestMethod {
    OPTIONS(1),
    GET(2),
    HEAD(3),
    POST(4),
    PUT(5),
    DELETE(6),
    TRACE(7),
    PROPFIND(8),
    PROPPATCH(9),
    MKCOL(10),
    COPY(11),
    MOVE(12),
    LOCK(13),
    UNLOCK(14),
    ACL(15),
    REPORT(16),
    VERSION_CONTROL(17),
    CHECKIN(18),
    CHECKOUT(19),
    UNCHECKOUT(20),
    SEARCH(21),
    MKWORKSPACE(22),
    UPDATE(23),
    LABEL(24),
    MERGE(25),
    BASELINE_CONTROL(26),
    MKACTIVITY(27),
    JK_STORED(255);

    private final int code;

    private RequestMethod(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static final RequestMethod forMethod(String method) {
        try {
            RequestMethod m = RequestMethod.valueOf(method.replace('-', '_'));
            return m;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

