/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient.impl.enums;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public enum ResponseHeader {
    ContentType("Content-Type", 40961),
    ContentLanguage("Content-Language", 40962),
    ContentLength("Content-Length", 40963),
    Date("Date", 40964),
    LastModified("Last-Modified", 40965),
    Location("Location", 40966),
    SetCookie("Set-Cookie", 40967),
    SetCookie2("Set-Cookie2", 40968),
    ServletEngine("Servlet-Engine", 40969),
    Status("Status", 40970),
    WWWAuthenticate("WWW-Authenticate", 40971);

    private final String key;
    private final int code;
    private static Map<Integer, String> headersByCode;

    private ResponseHeader(String key, int code) {
        this.key = key;
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public String getKey() {
        return this.key;
    }

    public static String getHeader(int code) {
        return headersByCode.get(code);
    }

    static {
        headersByCode = new TreeMap<Integer, String>();
        for (ResponseHeader rh : ResponseHeader.values()) {
            headersByCode.put(rh.getCode(), rh.getKey());
        }
        headersByCode = Collections.unmodifiableMap(headersByCode);
    }
}

