/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient.impl.handlers;

import com.github.jrialland.ajpclient.Constants;
import com.github.jrialland.ajpclient.Header;
import com.github.jrialland.ajpclient.impl.enums.ResponseHeader;
import com.github.jrialland.ajpclient.impl.handlers.AjpMessagesHandlerCallback;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjpMessagesHandler
extends ReplayingDecoder<Void>
implements Constants {
    private static final Logger LOGGER = LoggerFactory.getLogger(AjpMessagesHandler.class);
    private Long expectedBytes = null;

    private static final Logger getLog() {
        return LOGGER;
    }

    protected AjpMessagesHandlerCallback getCallback(Channel chann) {
        return (AjpMessagesHandlerCallback)chann.attr(AjpMessagesHandlerCallback.CHANNEL_ATTR).get();
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> _out) throws Exception {
        for (byte element : CONTAINER_MAGIC) {
            byte b = in.readByte();
            if (b == element) continue;
            String hex = "0" + Integer.toHexString(b);
            AjpMessagesHandler.getLog().warn("skipping unexpected byte 0x" + hex.substring(hex.length() - 2));
            return;
        }
        int length = in.readUnsignedShort();
        short prefix = in.readUnsignedByte();
        MessageType msgType = MessageType.forPrefix(prefix);
        if (msgType == null) {
            throw new IllegalStateException("unknown message prefix code : " + prefix);
        }
        if (AjpMessagesHandler.getLog().isDebugEnabled()) {
            String type = MessageType.forPrefix(prefix).name().toUpperCase();
            AjpMessagesHandler.getLog().debug(String.format("Received : %s (%s), payload size = %s bytes", type, (int)prefix, length));
        }
        if (prefix == 9) {
            this.getCallback(ctx.channel()).handleCPongMessage();
            return;
        }
        if (prefix == 4) {
            this.expectedBytes = this.readHeaders(ctx, in);
            return;
        }
        if (prefix == 3) {
            int chunkLength = in.readUnsignedShort();
            if (chunkLength > 0) {
                this.getCallback(ctx.channel()).handleSendBodyChunkMessage(in.readBytes(chunkLength));
                if (this.expectedBytes != null) {
                    this.expectedBytes = this.expectedBytes - (long)chunkLength;
                }
            }
            in.readByte();
            return;
        }
        if (prefix == 5) {
            boolean reuse = in.readBoolean();
            this.getCallback(ctx.channel()).handleEndResponseMessage(reuse);
            return;
        }
        if (prefix == 6) {
            int requestedLength = in.readUnsignedShort();
            this.getCallback(ctx.channel()).handleGetBodyChunkMessage(requestedLength);
            return;
        }
    }

    protected Long readHeaders(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        int statusCode = in.readUnsignedShort();
        String statusMessage = this.readString(in);
        int numHeaders = in.readUnsignedShort();
        if (AjpMessagesHandler.getLog().isDebugEnabled()) {
            AjpMessagesHandler.getLog().debug(" | HTTP/1.1 " + statusCode + " " + statusMessage);
        }
        Long expected = null;
        ArrayList<Header> headers = new ArrayList<Header>(numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            in.markReaderIndex();
            int code = in.readUnsignedShort();
            String headerName = ResponseHeader.getHeader(code);
            if (headerName == null) {
                in.resetReaderIndex();
                headerName = this.readString(in);
            }
            String value = this.readString(in);
            if (AjpMessagesHandler.getLog().isDebugEnabled()) {
                AjpMessagesHandler.getLog().debug(" | " + headerName + ": " + value);
            }
            if (headerName.equalsIgnoreCase("Content-Length")) {
                expected = Long.parseLong(value);
            }
            headers.add(new Header(headerName, value));
        }
        this.getCallback(ctx.channel()).handleSendHeadersMessage(statusCode, statusMessage, headers);
        return expected;
    }

    protected String readString(ByteBuf in) {
        short length = in.readShort();
        if (length < 0) {
            return null;
        }
        byte[] data = new byte[length];
        in.readBytes(data);
        in.readByte();
        return new String(data);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        AjpMessagesHandler.getLog().error("exception caught", cause);
        ctx.channel().close();
    }

    private static enum MessageType {
        SendBodyChunk(3),
        SendHeaders(4),
        EndResponse(5),
        GetBodyChunk(6),
        CPong(9);

        private final int code;
        private static Map<Integer, MessageType> byCodes;

        private static MessageType forPrefix(int code) {
            return byCodes.get(code);
        }

        private MessageType(int code) {
            this.code = code;
        }

        static {
            byCodes = new TreeMap<Integer, MessageType>();
            for (MessageType m : MessageType.values()) {
                byCodes.put(m.code, m);
            }
        }
    }
}

