/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient.impl.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutgoingFramesLogger
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutgoingFramesLogger.class);
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();

    private static final Logger getLog() {
        return LOGGER;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg == null) {
            OutgoingFramesLogger.getLog().debug(">>> (null)");
        } else if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            buf.markReaderIndex();
            byte[] data = new byte[buf.readableBytes()];
            buf.readBytes(data);
            OutgoingFramesLogger.getLog().debug(">>> " + OutgoingFramesLogger.bytesToHex(data));
            buf.resetReaderIndex();
        } else {
            OutgoingFramesLogger.getLog().debug(">>> " + msg.toString());
        }
        super.write(ctx, msg, promise);
    }

    private static final String bytesToHex(byte[] data) {
        char[] hexChars = new char[data.length * 2];
        for (int j = 0; j < data.length; ++j) {
            int v = data[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

