/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient.impl.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.slf4j.Logger;

public class Slf4jLogWriter
extends PrintWriter {
    private final StringBuffer buffer = new StringBuffer();
    private Logger log;
    private Level level;

    public Slf4jLogWriter(Level level, Logger log) {
        super(new NullWriter());
        this.level = level;
        this.log = log;
    }

    public void setLogger(Logger log) {
        this.flushBuffer();
        this.out = new NullWriter();
        this.log = log;
    }

    @Override
    public void close() {
        this.flushBuffer();
        super.close();
    }

    @Override
    public void flush() {
        this.flushBuffer();
        super.flush();
    }

    @Override
    public void write(int c) {
        this.buffer.append(c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.buffer.append(cbuf, off, len);
    }

    @Override
    public void write(String str, int off, int len) {
        this.buffer.append(str.substring(off, off + len));
    }

    @Override
    public void println() {
        this.flushBuffer();
    }

    private void flushBuffer() {
        if (this.buffer.length() == 0) {
            return;
        }
        switch (this.level) {
            case TRACE: {
                this.log.trace(this.buffer.toString());
                break;
            }
            case DEBUG: {
                this.log.debug(this.buffer.toString());
                break;
            }
            case INFO: {
                this.log.info(this.buffer.toString());
                break;
            }
            case WARN: {
                this.log.warn(this.buffer.toString());
                break;
            }
            case ERROR: {
                this.log.error(this.buffer.toString());
                break;
            }
        }
        this.buffer.setLength(0);
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level;
    }

    private static class NullWriter
    extends Writer {
        private NullWriter() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

