/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient.jmx;

import com.github.jrialland.ajpclient.jmx.ChannelPoolMonitorMBean;
import com.github.jrialland.ajpclient.pool.ChannelPool;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxExporter.class);

    private static final Logger getLog() {
        return LOGGER;
    }

    public static void exportMonitor(ChannelPool channelPool) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = JmxExporter.makeObjectName(channelPool.getHost(), channelPool.getPort());
            try {
                server.getMBeanInfo(objectName);
            }
            catch (InstanceNotFoundException e) {
                StandardMBean mBean = new StandardMBean(channelPool.getMonitor(), ChannelPoolMonitorMBean.class);
                server.registerMBean(mBean, objectName);
                JmxExporter.getLog().debug("new mBean registered for channelPool " + channelPool);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static ObjectName makeObjectName(String host, int port) throws MalformedObjectNameException {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("host", host);
        properties.put("port", Integer.toString(port));
        return new ObjectName(ChannelPool.class.getPackage().getName() + ".monitor", properties);
    }

    public static ChannelPoolMonitorMBean getMonitor(String jmxServerUrl, String host, int port) throws IOException {
        ObjectName objectName = null;
        try {
            objectName = JmxExporter.makeObjectName(host, port);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://:9999/jmxrmi");
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
        Set<ObjectInstance> set = mbsc.queryMBeans(objectName, null);
        if (set == null || set.isEmpty()) {
            return null;
        }
        return MBeanServerInvocationHandler.newProxyInstance(mbsc, objectName, ChannelPoolMonitorMBean.class, true);
    }
}

