/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient.jmx.impl;

import com.github.jrialland.ajpclient.jmx.ChannelPoolMonitorMBean;
import com.github.jrialland.ajpclient.pool.ChannelPool;
import io.netty.channel.Channel;
import java.util.Date;
import org.r358.poolnetty.common.PoolProvider;
import org.r358.poolnetty.common.PoolProviderListenerAdapter;

public class ChannelPoolMonitorImpl
extends PoolProviderListenerAdapter
implements ChannelPoolMonitorMBean {
    private Date startTime = new Date();
    private ChannelPool channelPool;
    private long createdConnections = 0L;
    private long closedConnections = 0L;
    private long leaseGranted = 0L;
    private long leaseYield = 0L;

    public ChannelPoolMonitorImpl(ChannelPool channelPool) {
        this.channelPool = channelPool;
    }

    public void connectionCreated(PoolProvider provider, Channel channel, boolean immortal) {
        ++this.createdConnections;
    }

    public void leaseGranted(PoolProvider provider, Channel channel, Object userObject) {
        ++this.leaseGranted;
    }

    public void leaseYield(PoolProvider provider, Channel channel, Object userObject) {
        ++this.leaseYield;
    }

    public void connectionClosed(PoolProvider provider, Channel channel) {
        ++this.closedConnections;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public int getActiveConnections() {
        return (int)(this.createdConnections - this.closedConnections);
    }

    @Override
    public String getHost() {
        return this.channelPool.getHost();
    }

    @Override
    public int getPort() {
        return this.channelPool.getPort();
    }

    @Override
    public void resetConnections() {
        this.channelPool.reset();
    }
}

