/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient.pool;

import com.github.jrialland.ajpclient.CPing;
import com.github.jrialland.ajpclient.Forward;
import com.github.jrialland.ajpclient.jmx.ChannelPoolMonitorMBean;
import com.github.jrialland.ajpclient.jmx.impl.ChannelPoolMonitorImpl;
import com.github.jrialland.ajpclient.pool.ChannelCallback;
import com.github.jrialland.ajpclient.pool.Channels;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.r358.poolnetty.common.BootstrapProvider;
import org.r358.poolnetty.common.ConnectionInfo;
import org.r358.poolnetty.common.ConnectionInfoProvider;
import org.r358.poolnetty.common.ContextExceptionHandler;
import org.r358.poolnetty.common.LeaseListener;
import org.r358.poolnetty.common.LeasedChannel;
import org.r358.poolnetty.common.PoolProvider;
import org.r358.poolnetty.common.PoolProviderListener;
import org.r358.poolnetty.pool.NettyConnectionPool;
import org.r358.poolnetty.pool.NettyConnectionPoolBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelPool.class);
    String host;
    int port;
    private NettyConnectionPool ncp;
    private final ChannelPoolMonitorImpl monitor;

    private static final Logger getLog() {
        return LOGGER;
    }

    protected ChannelPool(String host, int port) throws Exception {
        this.host = host;
        this.port = port;
        this.monitor = new ChannelPoolMonitorImpl(this);
        this.reset();
    }

    private static NettyConnectionPool createPool(final String host, final int port, ChannelPoolMonitorImpl monitor) {
        final Bootstrap bootstrap = Channels.newBootStrap(host, port);
        NettyConnectionPoolBuilder ncb = new NettyConnectionPoolBuilder(0, 200, 1000);
        ncb.withBootstrapProvider(new BootstrapProvider(){

            public Bootstrap createBootstrap(PoolProvider pp) {
                return bootstrap;
            }
        });
        ncb.withConnectionInfoProvider(new ConnectionInfoProvider(){

            public ConnectionInfo connectionInfo(PoolProvider pp) {
                InetSocketAddress remoteAddr = new InetSocketAddress(host, port);
                return new ConnectionInfo((SocketAddress)remoteAddr, null, (ChannelInitializer)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        Channels.initChannel(ch);
                    }
                });
            }
        });
        ncb.withContextExceptionHandler(new ContextExceptionHandler(){

            public boolean close(Throwable arg0, PoolProvider arg1) {
                return true;
            }
        });
        NettyConnectionPool pool = ncb.build();
        pool.addListener((PoolProviderListener)monitor);
        return pool;
    }

    public void execute(Forward forward) throws Exception {
        this.execute(forward.impl());
    }

    public void execute(CPing cping) throws Exception {
        this.execute(cping.impl());
    }

    public void execute(Forward forward, boolean reuseConnection) throws Exception {
        this.execute(forward.impl(), reuseConnection);
    }

    public void execute(CPing cping, boolean reuseConnection) throws Exception {
        this.execute(cping.impl(), reuseConnection);
    }

    protected void execute(ChannelCallback callback) throws Exception {
        this.execute(callback, true);
    }

    protected Channel getChannel() throws Exception {
        final Throwable[] th = new Throwable[1];
        Future future = this.ncp.leaseAsync(5, TimeUnit.SECONDS, null, new LeaseListener(){

            public void leaseRequest(boolean success, LeasedChannel channel, Throwable t) {
                th[0] = t;
            }
        });
        return (Channel)future.get(5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(ChannelCallback callback, boolean reuseConnection) throws Exception {
        ChannelPool.getLog().debug("getting channel from the connection pool ...");
        Channel channel = this.getChannel();
        ChannelPool.getLog().debug("... obtained " + channel);
        boolean reuse = false;
        try {
            callback.beforeUse(channel);
            reuse = callback.__doWithChannel(channel) && reuseConnection;
            try {
                callback.beforeRelease(channel);
            }
            catch (Exception e) {
                ChannelPool.getLog().warn("while releasing channel", (Throwable)e);
                reuse = false;
            }
        }
        finally {
            if (reuse) {
                ChannelPool.getLog().debug("returning channel " + channel + " to the connection pool");
            } else {
                ChannelPool.getLog().debug("invalidating channel " + channel);
                channel.close();
            }
            this.ncp.yield(channel);
        }
    }

    protected void destroy() {
        this.ncp.stop(true);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public ChannelPoolMonitorMBean getMonitor() {
        return this.monitor;
    }

    public void reset() {
        if (this.ncp != null) {
            this.ncp.stop(true);
        }
        this.ncp = ChannelPool.createPool(this.host, this.port, this.monitor);
        try {
            this.ncp.start(1000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

