/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient.pool;

import com.github.jrialland.ajpclient.impl.handlers.AjpMessagesHandler;
import com.github.jrialland.ajpclient.impl.handlers.OutgoingFramesLogger;
import com.github.jrialland.ajpclient.jmx.JmxExporter;
import com.github.jrialland.ajpclient.pool.ChannelPool;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.URI;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Channels {
    private static final Logger LOGGER = LoggerFactory.getLogger(Channels.class);
    private static final ThreadFactory THREADFACTORY = new ThreadFactory(){
        private final ThreadFactory wrapped = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.wrapped.newThread(r);
            t.setDaemon(true);
            return t;
        }
    };
    private EventLoopGroup eventLoopGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors(), THREADFACTORY);
    private static final Channels instance = new Channels();
    Map<String, ChannelPool> pools = new TreeMap<String, ChannelPool>();

    public static Logger getLog() {
        return LOGGER;
    }

    private Channels() {
    }

    public static synchronized ChannelPool getPool(String host, int port) throws Exception {
        String key = host + ":" + port;
        ChannelPool pool = instance.get(key);
        if (pool == null) {
            pool = new ChannelPool(host, port);
            instance.set(key, pool);
            JmxExporter.exportMonitor(pool);
            Channels.getLog().debug("added " + pool);
        }
        return pool;
    }

    public static ChannelPool getPool(URI uri) throws Exception {
        if (!uri.getScheme().equals("ajp")) {
            throw new IllegalArgumentException("only ajp:// uris are supported");
        }
        int port = uri.getPort();
        if (port < 0) {
            port = 8009;
        }
        return Channels.getPool(uri.getHost(), uri.getPort());
    }

    public static void setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        Channels.instance.eventLoopGroup = eventLoopGroup;
    }

    public static EventLoopGroup getEventLoopGroup() {
        return Channels.instance.eventLoopGroup;
    }

    protected ChannelPool get(String key) {
        return this.pools.get(key);
    }

    protected void set(String key, ChannelPool cp) {
        ChannelPool oldCp = this.pools.put(key, cp);
        if (oldCp != null) {
            oldCp.destroy();
        }
    }

    public static Channel connect(String host, int port) {
        return Channels.connect(host, port, Channels.getEventLoopGroup());
    }

    public static Bootstrap newBootStrap(String host, int port) {
        return Channels.newBootStrap(host, port, Channels.getEventLoopGroup());
    }

    public static Bootstrap newBootStrap(String host, int port, EventLoopGroup eventLoopGroup) {
        return (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(Channels.getEventLoopGroup())).remoteAddress(host, port).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.AUTO_READ, (Object)true);
    }

    public static void initChannel(Channel channel) {
        if (Channels.getLog().isTraceEnabled()) {
            channel.pipeline().addLast(new ChannelHandler[]{new OutgoingFramesLogger()});
        }
        channel.pipeline().addLast(new ChannelHandler[]{new AjpMessagesHandler()});
    }

    private static Channel connect(String host, int port, EventLoopGroup eventLoopGroup) {
        Bootstrap bootstrap = Channels.newBootStrap(host, port, eventLoopGroup);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                Channels.initChannel(ch);
            }
        });
        try {
            ChannelFuture cf = bootstrap.connect().sync();
            Channel channel = cf.channel();
            if (channel == null) {
                throw new IllegalStateException();
            }
            return channel;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

