/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient.servlet;

import com.github.jrialland.ajpclient.Attribute;
import com.github.jrialland.ajpclient.AttributeFactory;
import com.github.jrialland.ajpclient.Forward;
import com.github.jrialland.ajpclient.ForwardRequest;
import com.github.jrialland.ajpclient.ForwardResponse;
import com.github.jrialland.ajpclient.Header;
import com.github.jrialland.ajpclient.impl.enums.RequestMethod;
import com.github.jrialland.ajpclient.pool.ChannelPool;
import com.github.jrialland.ajpclient.pool.Channels;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjpServletProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AjpServletProxy.class);
    private final ChannelPool channelPool;

    public static Logger getLog() {
        return LOGGER;
    }

    private AjpServletProxy(ChannelPool channelPool) {
        this.channelPool = channelPool;
    }

    public static AjpServletProxy forHost(String host, int port) throws ServletException {
        try {
            ChannelPool channelPool = Channels.getPool(host, port);
            return new AjpServletProxy(channelPool);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void forward(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.forward(request, response, true);
    }

    public void forward(HttpServletRequest request, HttpServletResponse response, long timeout, TimeUnit unit, boolean reuseConnection) throws IOException, ServletException {
        RequestWrapper ajpRequest = new RequestWrapper(request);
        ResponseWrapper ajpResponse = new ResponseWrapper(response);
        try {
            this.channelPool.execute(new Forward(ajpRequest, ajpResponse, timeout, unit), reuseConnection);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IllegalArgumentException e) {
            response.sendError(400, e.getMessage());
        }
        catch (Exception e) {
            AjpServletProxy.getLog().error("could not proxy request", (Throwable)e);
            response.sendError(502);
        }
    }

    public void forward(HttpServletRequest request, HttpServletResponse response, boolean reuseConnection) throws IOException, ServletException {
        this.forward(request, response, -1L, null, reuseConnection);
    }

    private static class ResponseWrapper
    implements ForwardResponse {
        private final HttpServletResponse response;
        private final ServletOutputStream out;

        public ResponseWrapper(HttpServletResponse response) throws IOException {
            this.response = response;
            this.out = response.getOutputStream();
        }

        @Override
        public void atResponseBodyBegin() {
        }

        @Override
        public void atResponseBodyEnd(boolean reuse) throws IOException {
            this.out.flush();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.out;
        }

        @Override
        public void setHeader(String headerName, String value) {
            this.response.setHeader(headerName, value);
        }

        @Override
        public void setStatus(int code, String message) {
            this.response.setStatus(code, message);
        }
    }

    private static class RequestWrapper
    implements ForwardRequest {
        private RequestMethod requestMethod;
        private final HttpServletRequest request;
        private final URL requestUrl;
        private final InputStream in;
        private final List<Header> headers = new LinkedList<Header>();
        private final List<Attribute> attributes = new ArrayList<Attribute>();

        public RequestWrapper(HttpServletRequest request) throws IOException {
            this.request = request;
            this.requestUrl = new URL(request.getRequestURL().toString());
            this.requestMethod = RequestMethod.forMethod(request.getMethod());
            if (this.requestMethod == null) {
                this.requestMethod = RequestMethod.JK_STORED;
                this.attributes.add(AttributeFactory.createStoredMethodAttribute(request.getMethod()));
            }
            boolean hasContentLength = false;
            for (String headerName : Collections.list(request.getHeaderNames())) {
                if (headerName.equals("Content-Length")) {
                    hasContentLength = true;
                }
                for (String value : Collections.list(request.getHeaders(headerName))) {
                    this.headers.add(new Header(headerName, value));
                }
            }
            if (!hasContentLength && request.getContentLength() > -1) {
                this.headers.add(new Header("Content-Length", Long.toString(request.getContentLength())));
            }
            if (request.getQueryString() != null) {
                this.attributes.add(AttributeFactory.createQueryStringAttribute(request.getQueryString()));
            }
            if (request.getRemoteUser() != null) {
                this.attributes.add(AttributeFactory.createRemoteUserAttribute(request.getRemoteUser()));
            }
            this.attributes.add(AttributeFactory.createServletPathAttribute(request.getServletPath()));
            this.in = new BufferedInputStream((InputStream)request.getInputStream());
        }

        @Override
        public RequestMethod getMethod() {
            return this.requestMethod;
        }

        @Override
        public String getProtocol() {
            return this.request.getProtocol();
        }

        @Override
        public String getRequestUri() {
            return this.request.getRequestURI();
        }

        @Override
        public String getRemoteAddress() {
            return this.request.getRemoteAddr();
        }

        @Override
        public String getRemoteHost() {
            return this.request.getRemoteHost();
        }

        @Override
        public String getServerName() {
            return this.requestUrl.getHost();
        }

        @Override
        public int getServerPort() {
            return this.requestUrl.getPort();
        }

        @Override
        public Collection<Header> getHeaders() {
            return this.headers;
        }

        @Override
        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        @Override
        public InputStream getRequestBody() {
            return this.in;
        }

        @Override
        public boolean isSsl() {
            return this.request.isSecure();
        }
    }
}

