/*
 * Decompiled with CFR 0.152.
 */
package com.github.jshaptic.js4j;

import com.github.jshaptic.js4j.ContainerFactory;
import com.github.jshaptic.js4j.UniversalContainer;
import com.github.jshaptic.js4j.ValueCustomizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Lodash {
    private Lodash() {
    }

    public static boolean isArray(Object value) {
        return value != null && value instanceof UniversalContainer ? ((UniversalContainer)value).isArray() : value instanceof List || value instanceof Set || value instanceof Object[];
    }

    public static boolean isObject(Object value) {
        return value != null && value instanceof UniversalContainer ? !((UniversalContainer)value).isNull() && ((UniversalContainer)value).isObject() : value instanceof Map || value instanceof List || value instanceof Set;
    }

    public static boolean isNull(Object value) {
        return value != null && value instanceof UniversalContainer && ((UniversalContainer)value).isNull() || value == null && !(value instanceof UniversalContainer);
    }

    public static boolean isUndefined(Object value) {
        return value == null || value instanceof UniversalContainer && ((UniversalContainer)value).isUndefined();
    }

    public static boolean isEqual(UniversalContainer value, Object other) {
        return Lodash.baseIsEqual(value, other, null, null);
    }

    private static boolean baseIsEqual(UniversalContainer value, Object other, List<UniversalContainer> stackA, List<Object> stackB) {
        if (value == other) {
            return true;
        }
        if (value == null) {
            return ContainerFactory.undefinedContainer().equals(other);
        }
        if (other == null) {
            return value.equals(other);
        }
        if (Lodash.isUndefined(value) || Lodash.isUndefined(other) || Lodash.isNull(value) || Lodash.isNull(other) || !Lodash.isObject(value) && !Lodash.isObject(other)) {
            return value.equals(other);
        }
        return Lodash.baseIsEqualDeep(value, other, stackA, stackB);
    }

    private static boolean baseIsEqualDeep(UniversalContainer object, Object other, List<UniversalContainer> stackA, List<Object> stackB) {
        boolean isOtherArray;
        boolean isObjectArray = Lodash.isArray(object);
        if (isObjectArray != (isOtherArray = Lodash.isArray(other))) {
            return false;
        }
        stackA = stackA != null ? stackA : new ArrayList<UniversalContainer>();
        stackB = stackB != null ? stackB : new ArrayList<Object>();
        int length = stackA.size();
        while (length-- > 0) {
            if (stackA.get(length) != object) continue;
            return stackB.get(length) == other;
        }
        stackA.add(object);
        stackB.add(other);
        boolean result = false;
        if (other instanceof UniversalContainer) {
            result = isObjectArray ? Lodash.equalArrays(object, (UniversalContainer)other, stackA, stackB) : Lodash.equalObjects(object, (UniversalContainer)other, stackA, stackB);
        } else if (other instanceof List) {
            result = Lodash.equalArrays(object, (List)other, stackA, stackB);
        } else if (other instanceof Set) {
            result = Lodash.equalArrays(object, (Set)other, stackA, stackB);
        } else if (other instanceof Object[]) {
            result = Lodash.equalArrays(object, (Object[])other, stackA, stackB);
        } else if (other instanceof Map) {
            result = Lodash.equalObjects(object, (Map)other, stackA, stackB);
        }
        if (stackA.size() > 0) {
            stackA.remove(stackA.size() - 1);
        }
        if (stackB.size() > 0) {
            stackB.remove(stackB.size() - 1);
        }
        return result;
    }

    private static boolean equalArrays(UniversalContainer array, UniversalContainer other, List<UniversalContainer> stackA, List<Object> stackB) {
        int otherLength;
        int index = -1;
        int arrayLength = array.getLength(0);
        if (arrayLength != (otherLength = other.getLength(0).intValue())) {
            return false;
        }
        while (++index < arrayLength) {
            UniversalContainer otherValue;
            UniversalContainer arrayValue = array.get(index);
            if (arrayValue == (otherValue = other.get(index)) || Lodash.baseIsEqual(arrayValue, otherValue, stackA, stackB)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalArrays(UniversalContainer array, List<Object> other, List<UniversalContainer> stackA, List<Object> stackB) {
        int otherLength;
        int index = -1;
        int arrayLength = array.getLength(0);
        if (arrayLength != (otherLength = other.size())) {
            return false;
        }
        while (++index < arrayLength) {
            Object otherValue;
            UniversalContainer arrayValue = array.get(index);
            if (arrayValue == (otherValue = other.get(index)) || Lodash.baseIsEqual(arrayValue, otherValue, stackA, stackB)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalArrays(UniversalContainer array, Set<Object> other, List<UniversalContainer> stackA, List<Object> stackB) {
        int otherLength;
        int arrayLength = array.getLength(0);
        if (arrayLength != (otherLength = other.size())) {
            return false;
        }
        HashSet<Integer> indexSet = new HashSet<Integer>();
        for (Object otherValue : other) {
            boolean isMatchFound = false;
            for (int i = 0; i < arrayLength; ++i) {
                UniversalContainer arrayValue = array.get(i);
                if (!indexSet.contains(i) && (arrayValue == otherValue || Lodash.baseIsEqual(arrayValue, otherValue, stackA, stackB))) {
                    isMatchFound = true;
                    indexSet.add(i);
                    break;
                }
                if (!indexSet.contains(i)) continue;
                return false;
            }
            if (isMatchFound) continue;
            return false;
        }
        return true;
    }

    private static boolean equalArrays(UniversalContainer array, Object[] other, List<UniversalContainer> stackA, List<Object> stackB) {
        int otherLength;
        int index = -1;
        int arrayLength = array.getLength(0);
        if (arrayLength != (otherLength = other.length)) {
            return false;
        }
        while (++index < arrayLength) {
            Object otherValue;
            UniversalContainer arrayValue = array.get(index);
            if (arrayValue == (otherValue = other[index]) || Lodash.baseIsEqual(arrayValue, otherValue, stackA, stackB)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalObjects(UniversalContainer object, UniversalContainer other, List<UniversalContainer> stackA, List<Object> stackB) {
        Set<String> objectProperties = object.keys();
        Set<String> otherProperties = other.keys();
        if (object.getConstructor() != other.getConstructor() && object.getConstructor() != null && other.getConstructor() != null) {
            return false;
        }
        if (!objectProperties.equals(otherProperties)) {
            return false;
        }
        for (String key : objectProperties) {
            UniversalContainer otherValue;
            UniversalContainer arrayValue = object.get(key);
            if (arrayValue == (otherValue = other.get(key)) || Lodash.baseIsEqual(arrayValue, otherValue, stackA, stackB)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalObjects(UniversalContainer object, Map<Object, Object> other, List<UniversalContainer> stackA, List<Object> stackB) {
        Set<Object> otherProperties;
        Set<String> objectProperties = object.keys();
        if (!objectProperties.equals(otherProperties = other.keySet())) {
            return false;
        }
        for (String key : objectProperties) {
            Object otherValue;
            UniversalContainer arrayValue = object.get(key);
            if (arrayValue == (otherValue = other.get(key)) || Lodash.baseIsEqual(arrayValue, otherValue, stackA, stackB)) continue;
            return false;
        }
        return true;
    }

    public static UniversalContainer clone(UniversalContainer value) {
        if (value == null) {
            return ContainerFactory.undefinedContainer();
        }
        if (!Lodash.isObject(value)) {
            return value;
        }
        if (Lodash.isArray(value)) {
            return Lodash.arrayCopy(value, ContainerFactory.createArray());
        }
        return Lodash.extend(ContainerFactory.createObject(), value);
    }

    private static UniversalContainer arrayCopy(UniversalContainer source, UniversalContainer array) {
        int index = -1;
        int length = source.getLength(0);
        if (!array.test()) {
            array = ContainerFactory.createArray();
        }
        while (++index < length) {
            array.set(index, (Object)source.get(index));
        }
        return array;
    }

    public static UniversalContainer last(UniversalContainer array) {
        int length = array.test() ? array.getLength(0) : 0;
        return length > 0 ? array.get(length - 1) : ContainerFactory.undefinedContainer();
    }

    public static UniversalContainer extend(UniversalContainer object, UniversalContainer ... sources) {
        if (object == null) {
            return ContainerFactory.undefinedContainer();
        }
        if (sources == null || !Lodash.isObject(object)) {
            return object;
        }
        for (UniversalContainer source : sources) {
            if (source == null || !source.test()) continue;
            for (String key : source.keys()) {
                object.set(key, (Object)source.get(key));
            }
        }
        return object;
    }

    public static UniversalContainer merge(UniversalContainer object, UniversalContainer ... sources) {
        return Lodash.merge(object, null, sources);
    }

    public static UniversalContainer merge(UniversalContainer object, ValueCustomizer customizer, UniversalContainer ... sources) {
        if (object == null) {
            return ContainerFactory.undefinedContainer();
        }
        if (sources == null || !Lodash.isObject(object)) {
            return object;
        }
        for (UniversalContainer source : sources) {
            if (source == null || !source.test()) continue;
            Lodash.baseMerge(object, source, customizer, null, null);
        }
        return object;
    }

    private static UniversalContainer baseMerge(UniversalContainer object, UniversalContainer source, ValueCustomizer customizer, List<UniversalContainer> stackA, List<UniversalContainer> stackB) {
        boolean isSourceArray = Lodash.isArray(source);
        UniversalContainer elements = isSourceArray ? source : new UniversalContainer(source.keys());
        int index = -1;
        for (UniversalContainer e : elements) {
            UniversalContainer sourceValue;
            String key = isSourceArray ? String.valueOf(++index) : e.asString();
            UniversalContainer universalContainer = sourceValue = isSourceArray ? e : source.get(key);
            if (Lodash.isObject(sourceValue)) {
                stackA = stackA != null ? stackA : new ArrayList<UniversalContainer>();
                stackB = stackB != null ? stackB : new ArrayList<UniversalContainer>();
                Lodash.baseMergeDeep(object, source, key, customizer, stackA, stackB);
                continue;
            }
            UniversalContainer objectValue = object.get(key);
            UniversalContainer result = customizer != null ? customizer.customize(objectValue, sourceValue) : ContainerFactory.undefinedContainer();
            boolean isCommon = result.isUndefined();
            if (isCommon) {
                result = sourceValue;
            }
            if (result.isUndefined() && (!isSourceArray || object.has(key, false)) || !isCommon && result.equals(objectValue)) continue;
            object.set(key, (Object)result);
        }
        return object;
    }

    private static void baseMergeDeep(UniversalContainer object, UniversalContainer source, String key, ValueCustomizer customizer, List<UniversalContainer> stackA, List<UniversalContainer> stackB) {
        int length = stackA.size();
        UniversalContainer sourceValue = source.get(key);
        while (length-- > 0) {
            if (stackA.get(length) != sourceValue) continue;
            object.set(key, (Object)stackB.get(length));
            return;
        }
        UniversalContainer objectValue = object.get(key);
        UniversalContainer result = customizer != null ? customizer.customize(objectValue, sourceValue) : ContainerFactory.undefinedContainer();
        boolean isCommon = result.isUndefined();
        if (isCommon) {
            result = sourceValue;
            if (Lodash.isArray(sourceValue)) {
                result = Lodash.isArray(objectValue) ? objectValue : ContainerFactory.createArray();
            } else if (Lodash.isObject(sourceValue)) {
                result = Lodash.isObject(objectValue) ? objectValue : ContainerFactory.createObject();
            } else {
                isCommon = false;
            }
        }
        stackA.add(sourceValue);
        stackB.add(result);
        if (isCommon) {
            object.set(key, (Object)Lodash.baseMerge(result, sourceValue, customizer, stackA, stackB));
        } else if (!result.equals(objectValue)) {
            object.set(key, (Object)result);
        }
    }

    public static UniversalContainer values(UniversalContainer object) {
        UniversalContainer result = ContainerFactory.createArray();
        if (object == null) {
            return result;
        }
        for (String key : object.keys()) {
            result.push(object.get(key));
        }
        return result;
    }
}

