/*
 * Decompiled with CFR 0.152.
 */
package com.github.jshaptic.js4j;

import com.github.jshaptic.js4j.ContainerConstructor;
import com.github.jshaptic.js4j.ContainerException;
import com.github.jshaptic.js4j.ContainerFactory;
import com.github.jshaptic.js4j.Lodash;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class UniversalContainer
implements Iterable<UniversalContainer> {
    protected static final String BUILTIN_TYPE_UNDEFINED = "undefined";
    protected static final String BUILTIN_TYPE_NULL = "null";
    protected static final String BUILTIN_TYPE_BOOLEAN = "boolean";
    protected static final String BUILTIN_TYPE_NUMBER = "number";
    protected static final String BUILTIN_TYPE_STRING = "string";
    protected static final String BUILTIN_TYPE_OBJECT = "object";
    protected static final String BUILTIN_TYPE_UNKNOWN = "unknown";
    protected static final String BUILTIN_CLASS_UNDEFINED = "Undefined";
    protected static final String BUILTIN_CLASS_NULL = "Null";
    protected static final String BUILTIN_CLASS_BOOLEAN = "Boolean";
    protected static final String BUILTIN_CLASS_NUMBER = "Number";
    protected static final String BUILTIN_CLASS_STRING = "String";
    protected static final String BUILTIN_CLASS_LITERAL = "Literal";
    protected static final String BUILTIN_CLASS_OBJECT = "Object";
    protected static final String BUILTIN_CLASS_ARRAY = "Array";
    protected static final String BUILTIN_PROPERTY_CONSTRUCTOR = "constructor";
    protected static final String BUILTIN_PROPERTY_LENGTH = "length";
    protected ContainerValue inner = null;
    protected UniversalContainer proto = null;
    protected ContainerConstructor constructor = null;
    protected Integer length = null;

    protected UniversalContainer() {
        this(ContainerConstructor.UNDEFINED);
    }

    protected UniversalContainer(ContainerConstructor type) {
        if (type == null) {
            type = ContainerConstructor.UNDEFINED;
        }
        switch (type) {
            case UNDEFINED: {
                this.setUndefined();
                break;
            }
            case NULL: {
                this.setNull();
                break;
            }
            case LITERAL: {
                this.setLiteral(null);
                break;
            }
            case OBJECT: {
                this.setObject();
                break;
            }
            case ARRAY: {
                this.setArray();
            }
        }
    }

    public UniversalContainer(Object value) {
        UniversalContainer.wrapValue(this, value);
    }

    public UniversalContainer(UniversalContainer container) {
        UniversalContainer.wrapValue(this, container);
    }

    public UniversalContainer(Object[] array) {
        UniversalContainer.wrapValue(this, array);
    }

    public UniversalContainer(Iterable<Object> list) {
        UniversalContainer.wrapValue(this, list);
    }

    public UniversalContainer(Map<Object, Object> map) {
        UniversalContainer.wrapValue(this, map);
    }

    public boolean asBoolean() {
        if (!this.isString() && this.has(BUILTIN_PROPERTY_LENGTH, false) && this.getLength(0) == 1) {
            return this.get(0).asBoolean();
        }
        return ContainerValue.asBoolean(this.inner);
    }

    public boolean asBoolean(int index) {
        return this.get(index).asBoolean();
    }

    public boolean asBoolean(String property) {
        return this.get(property).asBoolean();
    }

    public double asDouble() {
        if (!this.isString() && this.has(BUILTIN_PROPERTY_LENGTH, false) && this.getLength(0) == 1) {
            return this.get(0).asDouble();
        }
        return ContainerValue.asNumber(this.inner).doubleValue();
    }

    public double asDouble(int index) {
        return this.get(index).asDouble();
    }

    public double asDouble(String property) {
        return this.get(property).asDouble();
    }

    public int asInt() {
        if (!this.isString() && this.has(BUILTIN_PROPERTY_LENGTH, false) && this.getLength(0) == 1) {
            return this.get(0).asInt();
        }
        return ContainerValue.asNumber(this.inner).intValue();
    }

    public int asInt(int index) {
        return this.get(index).asInt();
    }

    public int asInt(String property) {
        return this.get(property).asInt();
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        UniversalContainer.asString(this, sb, null);
        return sb.toString();
    }

    private static void asString(UniversalContainer container, StringBuilder sb, List<UniversalContainer> stack) {
        if (!container.isString() && container.has(BUILTIN_PROPERTY_LENGTH, false)) {
            stack = stack != null ? stack : new ArrayList<UniversalContainer>();
            int index = stack.size();
            while (index-- > 0) {
                if (stack.get(index) != container) continue;
                return;
            }
            stack.add(container);
            int length = container.getLength(0);
            for (int i = 0; i < length; ++i) {
                UniversalContainer value = container.get(i);
                UniversalContainer.asString(value, sb, stack);
                if (i == length - 1) continue;
                sb.append(",");
            }
            if (stack.size() > 0) {
                stack.remove(stack.size() - 1);
            }
        } else if (container.isObject() && !container.isNull()) {
            sb.append("[object Object]");
        } else {
            sb.append(ContainerValue.asString(container));
        }
    }

    public String asString(int index) {
        return this.get(index).asString();
    }

    public String asString(String property) {
        return this.get(property).asString();
    }

    public <T> List<T> asList(Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        if (!this.isString() && this.test(BUILTIN_PROPERTY_LENGTH)) {
            for (UniversalContainer value : this) {
                list.add(UniversalContainer.castValue(value, clazz));
            }
        } else if (this.inner instanceof PrimitiveLiteralValue) {
            list.add(UniversalContainer.castValue(this, clazz));
        }
        return list;
    }

    public <T> Map<String, T> asMap(Class<T> clazz) {
        HashMap<String, T> map = new HashMap<String, T>();
        if (this.isObject()) {
            for (String k : this.keys()) {
                map.put(k, UniversalContainer.castValue(this.get(k), clazz));
            }
        }
        return map;
    }

    public <T> T valueOf() {
        if (this.inner instanceof PrimitiveLiteralValue) {
            return (T)this.inner.literal;
        }
        return null;
    }

    public <T> T valueOf(int index) {
        return this.get(index).valueOf();
    }

    public <T> T valueOf(String property) {
        return this.get(property).valueOf();
    }

    public boolean isArray() {
        return this.inner instanceof ArrayValue;
    }

    public boolean isArray(int index) {
        return this.get(index).isArray();
    }

    public boolean isArray(String property) {
        return this.get(property).isArray();
    }

    public boolean isBoolean() {
        return ContainerValue.isBoolean(this.inner);
    }

    public boolean isBoolean(int index) {
        return this.get(index).isBoolean();
    }

    public boolean isBoolean(String property) {
        return this.get(property).isBoolean();
    }

    public boolean isObject() {
        return this.inner instanceof ObjectValue || this.inner instanceof NullValue;
    }

    public boolean isObject(int index) {
        return this.get(index).isObject();
    }

    public boolean isObject(String property) {
        return this.get(property).isObject();
    }

    public boolean isNull() {
        return this.inner instanceof NullValue;
    }

    public boolean isNull(int index) {
        return this.get(index).isNull();
    }

    public boolean isNull(String property) {
        return this.get(property).isNull();
    }

    public boolean isNumber() {
        return ContainerValue.isNumber(this.inner);
    }

    public boolean isNumber(int index) {
        return this.get(index).isNumber();
    }

    public boolean isNumber(String property) {
        return this.get(property).isNumber();
    }

    public boolean isString() {
        return ContainerValue.isString(this.inner);
    }

    public boolean isString(int index) {
        return this.get(index).isString();
    }

    public boolean isString(String property) {
        return this.get(property).isString();
    }

    public boolean isUndefined() {
        return this.inner instanceof UndefinedValue;
    }

    public boolean isUndefined(int index) {
        return this.get(index).isUndefined();
    }

    public boolean isUndefined(String property) {
        return this.get(property).isUndefined();
    }

    public boolean test() {
        if (this.isBoolean()) {
            return this.asBoolean();
        }
        if (this.isNumber()) {
            return this.asInt() != 0;
        }
        if (this.isString()) {
            return !this.asString().isEmpty();
        }
        if (this.inner instanceof PrimitiveLiteralValue) {
            return this.inner.literal != null;
        }
        return !this.isUndefined() && !this.isNull();
    }

    public boolean test(int index) {
        return this.get(index).test();
    }

    public boolean test(String property) {
        switch (property = StringUtils.defaultString((String)property)) {
            case "constructor": {
                return this.has(BUILTIN_PROPERTY_CONSTRUCTOR, false) && this.getConstructor() != null;
            }
            case "length": {
                return this.has(BUILTIN_PROPERTY_LENGTH, false) && this.getLength(0) > 0;
            }
        }
        return this.get(property).test();
    }

    public UniversalContainer get(int index) {
        if (this.isString()) {
            String s = this.asString();
            if (index >= 0 && index < s.length()) {
                return new UniversalContainer(String.valueOf(s.charAt(index)));
            }
            return ContainerFactory.undefinedContainer();
        }
        return this.get(this.indexToProperty(index));
    }

    public UniversalContainer get(String property) {
        property = StringUtils.defaultString((String)property);
        this.canReadProperty(property, true);
        if (this.isString() && this.canConvertPropertyToIndex(property)) {
            return this.get(this.propertyToIndex(property));
        }
        if (this.isObject()) {
            if (this.inner.table.containsKey(property)) {
                return this.inner.table.get(property);
            }
            if (this.proto != null && !this.proto.isUndefined() && !this.proto.isNull()) {
                return this.proto.get(property);
            }
        }
        return ContainerFactory.undefinedContainer();
    }

    public ContainerConstructor getConstructor() {
        this.canReadProperty(BUILTIN_PROPERTY_CONSTRUCTOR, true);
        if (this.constructor == null && this.proto != null && this.proto.canReadProperty(BUILTIN_PROPERTY_CONSTRUCTOR, false)) {
            return this.proto.getConstructor();
        }
        return this.constructor;
    }

    public Integer getLength() {
        return this.getLength(null);
    }

    public Integer getLength(Integer defaultLength) {
        this.canReadProperty(BUILTIN_PROPERTY_LENGTH, true);
        Integer result = this.length;
        if (result == null && this.proto != null && this.proto.canReadProperty(BUILTIN_PROPERTY_LENGTH, false)) {
            result = this.proto.getLength(defaultLength);
        }
        return result != null ? result : defaultLength;
    }

    public UniversalContainer getProto() {
        return ContainerFactory.undefinedContainerIfNull(this.proto);
    }

    public UniversalContainer set(int index, Object value) {
        if (this.isArray()) {
            if (index >= this.getLength(0)) {
                this.setLength(index + 1);
            }
            this.inner.table.put(this.indexToProperty(index), UniversalContainer.wrapValue(value));
            return this;
        }
        return this.set(this.indexToProperty(index), value);
    }

    public UniversalContainer set(String property, Object value) {
        property = StringUtils.defaultString((String)property);
        this.canWriteProperty(property, true);
        if (this.isArray() && this.canConvertPropertyToIndex(property)) {
            return this.set(this.propertyToIndex(property), value);
        }
        if (this.isObject()) {
            this.inner.table.put(property, UniversalContainer.wrapValue(value));
        }
        return this;
    }

    public void setLength(int newLength) {
        this.canWriteProperty(BUILTIN_PROPERTY_LENGTH, true);
        if (newLength < 0) {
            throw new ContainerException("Cannot set negative length");
        }
        if (this.isArray() && this.length != null && this.length > newLength) {
            for (int i = newLength; i < this.length; ++i) {
                this.delete(i);
            }
        }
        this.length = newLength;
    }

    public UniversalContainer concat(Object ... sources) {
        this.canInvokeMethod("concat", true);
        if (this.isString()) {
            return this.concatString(sources);
        }
        return this.concatArray(sources);
    }

    private UniversalContainer concatString(Object ... sources) {
        StringBuilder sb = new StringBuilder(this.asString());
        if (sources != null) {
            for (Object source : sources) {
                sb.append(UniversalContainer.wrapValue(source).toString());
            }
        }
        return new UniversalContainer(sb.toString());
    }

    private UniversalContainer concatArray(Object ... sources) {
        UniversalContainer result = ContainerFactory.createArray();
        int index = UniversalContainer.concatArrayAppend(this, result, 0);
        if (sources != null) {
            for (Object source : sources) {
                index = UniversalContainer.concatArrayAppend(UniversalContainer.wrapValue(source), result, index);
            }
        }
        return result;
    }

    private static int concatArrayAppend(UniversalContainer value, UniversalContainer result, int index) {
        if (value.isArray()) {
            for (UniversalContainer v : value) {
                result.set(index++, (Object)v);
            }
        } else {
            result.set(index++, (Object)value);
        }
        return index;
    }

    public UniversalContainer create() {
        this.canInvokeMethod("create", true);
        UniversalContainer oc = ContainerFactory.createObject();
        oc.constructor = null;
        oc.proto = this;
        return oc;
    }

    public void delete(int index) {
        this.delete(this.indexToProperty(index));
    }

    public void delete(String property) {
        property = StringUtils.defaultString((String)property);
        this.canReadProperty(property, true);
        if (this.isObject()) {
            this.inner.table.remove(property);
        }
    }

    public boolean has(int index) {
        return this.has(index, true);
    }

    public boolean has(String property) {
        return this.has(property, true);
    }

    public boolean has(int index, boolean own) {
        if (this.isString()) {
            return index >= 0 && index < this.getLength(0);
        }
        return this.has(this.indexToProperty(index), own);
    }

    public boolean has(String property, boolean own) {
        property = StringUtils.defaultString((String)property);
        if (this.isString() && this.canConvertPropertyToIndex(property)) {
            return this.has(this.propertyToIndex(property), own);
        }
        if (this.inner.isPropertyExists(property)) {
            return true;
        }
        if (!own && this.proto != null) {
            return this.proto.has(property, own);
        }
        return false;
    }

    public int indexOf(Object value) {
        this.canInvokeMethod("indexOf", true);
        if (this.isString()) {
            return this.indexOfString(value);
        }
        return this.indexOfArray(value);
    }

    private int indexOfString(Object value) {
        if (value == null) {
            return -1;
        }
        return this.asString().indexOf(value.toString());
    }

    private int indexOfArray(Object value) {
        int length = this.getLength(0);
        for (int i = 0; i < length; ++i) {
            if (!this.has(i, false) || !this.get(i).equals(value)) continue;
            return i;
        }
        return -1;
    }

    public Set<String> keys() {
        return this.keys(true);
    }

    public Set<String> keys(boolean own) {
        if (this.isString()) {
            HashSet<String> keys = new HashSet<String>();
            int length = this.getLength(0);
            for (int i = 0; i < length; ++i) {
                keys.add(this.indexToProperty(i));
            }
            return Collections.unmodifiableSet(keys);
        }
        if (this.isObject() && !this.isNull()) {
            if (own || !own && this.proto == null) {
                return Collections.unmodifiableSet(this.inner.table.keySet());
            }
            HashSet<String> keys = new HashSet<String>(this.inner.table.keySet());
            keys.addAll(this.proto.keys(own));
            return Collections.unmodifiableSet(keys);
        }
        return Collections.emptySet();
    }

    public UniversalContainer pop() {
        this.canInvokeMethod("pop", true);
        int length = this.getLength(0);
        this.setLength(length);
        if (length > 0) {
            UniversalContainer result = this.get(length - 1);
            this.inner.table.remove(this.indexToProperty(length - 1));
            this.dereaseLength();
            return result;
        }
        return ContainerFactory.undefinedContainer();
    }

    public int push(Object ... values) {
        this.canInvokeMethod("push", true);
        if (values == null) {
            return this.getLength(0);
        }
        int length = this.getLength(0);
        this.setLength(length);
        for (Object v : values) {
            this.inner.table.put(this.indexToProperty(length), UniversalContainer.wrapValue(v));
            this.increaseLength();
        }
        return this.getLength(0);
    }

    public UniversalContainer shift() {
        this.canInvokeMethod("shift", true);
        int length = this.getLength(0);
        this.setLength(length);
        if (length > 0) {
            UniversalContainer result = this.get(0);
            for (int i = 0; i < length - 1; ++i) {
                if (this.has(i + 1, false)) {
                    this.set(i, (Object)this.get(i + 1));
                    continue;
                }
                this.delete(i);
            }
            this.inner.table.remove(this.indexToProperty(length - 1));
            this.dereaseLength();
            return result;
        }
        return ContainerFactory.undefinedContainer();
    }

    public UniversalContainer splice(int start, int deleteCount) {
        this.canInvokeMethod("splice", true);
        int length = this.getLength(0);
        UniversalContainer result = ContainerFactory.createArray();
        this.setLength(length);
        if (length > 0) {
            start = start < 0 ? length + start : start;
            int j = 0;
            for (int i = start = start < 0 ? 0 : start; i < length; ++i) {
                String property = this.indexToProperty(i);
                if (i < start + deleteCount) {
                    result.set(j++, (Object)this.get(property));
                    this.inner.table.remove(property);
                    this.dereaseLength();
                    continue;
                }
                if (i >= length || deleteCount <= 0) continue;
                this.set(this.indexToProperty(i - deleteCount), (Object)this.get(property));
                this.inner.table.remove(property);
            }
        }
        return result;
    }

    public UniversalContainer clone() {
        return Lodash.clone(this);
    }

    public boolean deepEquals(Object other) {
        return Lodash.isEqual(this, other);
    }

    public UniversalContainer extend(UniversalContainer ... sources) {
        return Lodash.extend(this, sources);
    }

    public UniversalContainer last() {
        return Lodash.last(this);
    }

    public UniversalContainer merge(UniversalContainer ... sources) {
        return Lodash.merge(this, sources);
    }

    public UniversalContainer values() {
        return Lodash.values(this);
    }

    public boolean equals(Object other) {
        if (this.inner instanceof PrimitiveLiteralValue && this.inner.literal == null && other == null) {
            return true;
        }
        if (other == null) {
            return this.isUndefined();
        }
        ContainerValue a = this.inner;
        ContainerValue b = null;
        if (other instanceof ContainerValue) {
            b = (ContainerValue)other;
        } else if (other instanceof UniversalContainer) {
            b = ((UniversalContainer)other).inner;
        }
        if (b != null) {
            if (a instanceof UndefinedValue && b instanceof UndefinedValue) {
                return true;
            }
            if (a instanceof NullValue && b instanceof NullValue) {
                return true;
            }
            if (ContainerValue.isNumber(a) && ContainerValue.isNumber(b) && ContainerValue.asNumber(a).doubleValue() == ContainerValue.asNumber(b).doubleValue()) {
                return true;
            }
            if (a instanceof PrimitiveLiteralValue && a.getClassName() == b.getClassName() && (a.literal == null && b.literal == null || a.literal != null && b.literal != null && a.literal.equals(b.literal))) {
                return true;
            }
            return a == b;
        }
        if (a instanceof PrimitiveLiteralValue) {
            if (ContainerValue.isNumber(a) && ContainerValue.isNumber(other)) {
                return ContainerValue.asNumber(a).doubleValue() == ContainerValue.asNumber(other).doubleValue();
            }
            return a.literal != null && a.literal.equals(other);
        }
        return false;
    }

    @Override
    public Iterator<UniversalContainer> iterator() {
        if (this.has(BUILTIN_PROPERTY_LENGTH, false)) {
            return new Iterator<UniversalContainer>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < UniversalContainer.this.getLength(0);
                }

                @Override
                public UniversalContainer next() {
                    if (UniversalContainer.this.has(this.index, false)) {
                        return UniversalContainer.this.get(this.index++);
                    }
                    ++this.index;
                    return ContainerFactory.undefinedContainer();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (this.isObject()) {
            return new Iterator<UniversalContainer>(){
                private Iterator<String> iter;
                {
                    this.iter = UniversalContainer.this.keys(false).iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public UniversalContainer next() {
                    return UniversalContainer.wrapValue(this.iter.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<UniversalContainer>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public UniversalContainer next() {
                return ContainerFactory.undefinedContainer();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        if (this.isUndefined() || this.isNull()) {
            return this.inner.toString();
        }
        return this.asString();
    }

    protected boolean canReadProperty(int index, boolean throwError) {
        return this.canReadProperty(this.indexToProperty(index), throwError);
    }

    protected boolean canReadProperty(String property, boolean throwError) {
        property = StringUtils.defaultString((String)property);
        if (this.isUndefined() || this.isNull()) {
            if (throwError) {
                throw new ContainerException("Cannot get '" + property + "' property from " + this.inner.getClassName() + " container");
            }
            return false;
        }
        return true;
    }

    protected boolean canWriteProperty(int index, boolean throwError) {
        return this.canWriteProperty(this.indexToProperty(index), throwError);
    }

    protected boolean canWriteProperty(String property, boolean throwError) {
        property = StringUtils.defaultString((String)property);
        if (this.isUndefined() || this.isNull()) {
            if (throwError) {
                throw new ContainerException("Cannot set '" + property + "' property in " + this.inner.getClassName() + " container");
            }
            return false;
        }
        return true;
    }

    protected boolean canInvokeMethod(String method, boolean throwError) {
        if (!this.inner.isMethodSupported(method = StringUtils.defaultString((String)method)) && (this.proto == null || this.proto != null && !this.proto.canInvokeMethod(method, false))) {
            if (throwError) {
                throw new ContainerException("Method '" + method + "' is not available for " + this.inner.getClassName() + " container");
            }
            return false;
        }
        return true;
    }

    protected void dereaseLength() {
        if (this.length == null) {
            throw new ContainerException("Cannot decrease length, because it doesn't exist");
        }
        Integer n = this.length;
        Integer n2 = this.length = Integer.valueOf(this.length - 1);
    }

    protected void increaseLength() {
        if (this.length == null) {
            throw new ContainerException("Cannot increase length, because it doesn't exist");
        }
        Integer n = this.length;
        Integer n2 = this.length = Integer.valueOf(this.length + 1);
    }

    protected boolean canConvertPropertyToIndex(String property) {
        property = StringUtils.defaultString((String)property);
        return NumberUtils.isParsable((String)property);
    }

    protected String indexToProperty(int index) {
        return String.valueOf(index);
    }

    protected int propertyToIndex(String property) {
        property = StringUtils.defaultString((String)property);
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            throw new ContainerException("Property '" + property + "' cannot be converted to index");
        }
    }

    protected static <T> T castValue(UniversalContainer value, Class<T> clazz) {
        if (value == null || clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(Boolean.class)) {
            return (T)Boolean.valueOf(value.asBoolean());
        }
        if (clazz.isAssignableFrom(Double.class)) {
            return (T)Double.valueOf(value.asDouble());
        }
        if (clazz.isAssignableFrom(Integer.class)) {
            return (T)Integer.valueOf(value.asInt());
        }
        if (clazz.isAssignableFrom(String.class)) {
            return (T)value.asString();
        }
        return value.valueOf();
    }

    protected void setArray() {
        this.constructor = ContainerConstructor.ARRAY;
        this.inner = new ArrayValue();
        this.setLength(0);
    }

    protected void setArray(Object[] array) {
        this.setArray();
        int i = 0;
        for (Object v : array) {
            this.set(i++, (Object)UniversalContainer.wrapValue(v));
        }
    }

    protected void setArray(Iterable<Object> list) {
        this.setArray();
        int i = 0;
        for (Object v : list) {
            this.set(i++, (Object)UniversalContainer.wrapValue(v));
        }
    }

    protected void setLiteral(Object literal) {
        this.constructor = ContainerConstructor.LITERAL;
        this.inner = new PrimitiveLiteralValue(literal);
        if (this.isString()) {
            this.setLength(this.asString().length());
        }
    }

    protected void setNull() {
        this.constructor = ContainerConstructor.NULL;
        this.inner = new NullValue();
    }

    protected void setObject() {
        this.constructor = ContainerConstructor.OBJECT;
        this.inner = new ObjectValue();
    }

    protected void setObject(Map<Object, Object> map) {
        this.setObject();
        for (Object k : map.keySet()) {
            this.set(k.toString(), (Object)UniversalContainer.wrapValue(map.get(k)));
        }
    }

    protected void setUndefined() {
        this.constructor = ContainerConstructor.UNDEFINED;
        this.inner = new UndefinedValue();
    }

    protected static UniversalContainer wrapValue(Object value) {
        return UniversalContainer.wrapValue(null, value);
    }

    protected static UniversalContainer wrapValue(ContainerValue value) {
        return UniversalContainer.wrapValue(null, value);
    }

    protected static UniversalContainer wrapValue(UniversalContainer container) {
        return UniversalContainer.wrapValue(null, container);
    }

    protected static UniversalContainer wrapValue(Object[] array) {
        return UniversalContainer.wrapValue(null, array);
    }

    protected static UniversalContainer wrapValue(List<Object> list) {
        return UniversalContainer.wrapValue(null, list);
    }

    protected static UniversalContainer wrapValue(Map<Object, Object> map) {
        return UniversalContainer.wrapValue(null, map);
    }

    protected static UniversalContainer wrapValue(UniversalContainer obj, Object value) {
        UniversalContainer wrap;
        if (obj == null && value == null) {
            return ContainerFactory.undefinedContainer();
        }
        if (value instanceof ContainerValue) {
            wrap = UniversalContainer.wrapValue(obj, (ContainerValue)value);
        } else if (value instanceof UniversalContainer) {
            wrap = UniversalContainer.wrapValue(obj, (UniversalContainer)value);
        } else if (value instanceof Object[]) {
            wrap = UniversalContainer.wrapValue(obj, (Object[])value);
        } else if (value instanceof Iterable) {
            wrap = UniversalContainer.wrapValue(obj, (Iterable)value);
        } else if (value instanceof Map) {
            wrap = UniversalContainer.wrapValue(obj, (Map)value);
        } else {
            wrap = obj != null ? obj : new UniversalContainer();
            wrap.setLiteral(value);
        }
        return wrap;
    }

    protected static UniversalContainer wrapValue(UniversalContainer obj, ContainerValue value) {
        if (obj == null && value == null) {
            return ContainerFactory.undefinedContainer();
        }
        UniversalContainer wrap = obj != null ? obj : new UniversalContainer();
        wrap.inner = value;
        return wrap;
    }

    protected static UniversalContainer wrapValue(UniversalContainer obj, UniversalContainer container) {
        if (obj == null && container == null) {
            return ContainerFactory.undefinedContainer();
        }
        if (obj == null && container != null) {
            return container;
        }
        if (obj != null && container == null) {
            return obj;
        }
        obj.inner = container.inner;
        obj.proto = container.proto;
        obj.constructor = container.constructor;
        obj.length = container.length;
        return obj;
    }

    protected static UniversalContainer wrapValue(UniversalContainer obj, Object[] array) {
        if (obj == null && array == null) {
            return ContainerFactory.undefinedContainer();
        }
        UniversalContainer wrap = obj != null ? obj : new UniversalContainer();
        wrap.setArray(array);
        return wrap;
    }

    protected static UniversalContainer wrapValue(UniversalContainer obj, Iterable<Object> list) {
        if (obj == null && list == null) {
            return ContainerFactory.undefinedContainer();
        }
        UniversalContainer wrap = obj != null ? obj : new UniversalContainer();
        wrap.setArray(list);
        return wrap;
    }

    protected static UniversalContainer wrapValue(UniversalContainer obj, Map<Object, Object> map) {
        if (obj == null && map == null) {
            return ContainerFactory.undefinedContainer();
        }
        UniversalContainer wrap = obj != null ? obj : new UniversalContainer();
        wrap.setObject(map);
        return wrap;
    }

    protected static class ArrayValue
    extends ObjectValue {
        public ArrayValue() {
            this.builtinProperties.add(UniversalContainer.BUILTIN_PROPERTY_LENGTH);
            this.supportedMethods.add("from");
            this.supportedMethods.add("isArray");
            this.supportedMethods.add("of");
            this.supportedMethods.add("copyWithin");
            this.supportedMethods.add("fill");
            this.supportedMethods.add("pop");
            this.supportedMethods.add("push");
            this.supportedMethods.add("reverse");
            this.supportedMethods.add("shift");
            this.supportedMethods.add("sort");
            this.supportedMethods.add("splice");
            this.supportedMethods.add("unshift");
            this.supportedMethods.add("concat");
            this.supportedMethods.add("join");
            this.supportedMethods.add("slice");
            this.supportedMethods.add("indexOf");
            this.supportedMethods.add("lastIndexOf");
            this.supportedMethods.add("forEach");
            this.supportedMethods.add("entries");
            this.supportedMethods.add("every");
            this.supportedMethods.add("some");
            this.supportedMethods.add("filter");
            this.supportedMethods.add("find");
            this.supportedMethods.add("findIndex");
            this.supportedMethods.add("keys");
            this.supportedMethods.add("map");
            this.supportedMethods.add("reduce");
            this.supportedMethods.add("reduceRight");
            this.supportedMethods.add("values");
        }

        @Override
        public String getClassName() {
            return UniversalContainer.BUILTIN_CLASS_ARRAY;
        }
    }

    protected static class ObjectValue
    extends ContainerValue {
        public ObjectValue() {
            this.table = new HashMap();
            this.builtinProperties.add(UniversalContainer.BUILTIN_PROPERTY_CONSTRUCTOR);
            this.supportedMethods.add("assign");
            this.supportedMethods.add("create");
            this.supportedMethods.add("defineProperty");
            this.supportedMethods.add("defineProperties");
            this.supportedMethods.add("freeze");
            this.supportedMethods.add("getOwnPropertyDescriptor");
            this.supportedMethods.add("getOwnPropertyNames");
            this.supportedMethods.add("getOwnPropertySymbols");
            this.supportedMethods.add("getPrototypeOf");
            this.supportedMethods.add("is");
            this.supportedMethods.add("isExtensible");
            this.supportedMethods.add("isFrozen");
            this.supportedMethods.add("isSealed");
            this.supportedMethods.add("keys");
            this.supportedMethods.add("preventExtensions");
            this.supportedMethods.add("seal");
            this.supportedMethods.add("setPrototypeOf");
            this.supportedMethods.add("hasOwnProperty");
            this.supportedMethods.add("isPrototypeOf");
            this.supportedMethods.add("propertyIsEnumerable");
            this.supportedMethods.add("toLocaleString");
            this.supportedMethods.add("toString");
            this.supportedMethods.add("valueOf");
        }

        @Override
        public String getClassName() {
            return UniversalContainer.BUILTIN_CLASS_OBJECT;
        }

        @Override
        public String getType() {
            return UniversalContainer.BUILTIN_TYPE_OBJECT;
        }
    }

    protected static class PrimitiveLiteralValue
    extends ContainerValue {
        public PrimitiveLiteralValue(Object value) {
            if (value instanceof ContainerValue) {
                throw new ContainerException("Literal value cannot hold other inner value class");
            }
            if (value instanceof UniversalContainer) {
                throw new ContainerException("Literal value cannot hold container");
            }
            if (value instanceof Object[]) {
                throw new ContainerException("Literal value cannot hold java array, use ArrayValue container instead");
            }
            if (value instanceof Iterable) {
                throw new ContainerException("Literal value cannot hold Iterable class, use ArrayValue container instead");
            }
            if (value instanceof Map) {
                throw new ContainerException("Literal value cannot hold Map class, use ObjectValue container instead");
            }
            this.literal = value;
            this.builtinProperties.add(UniversalContainer.BUILTIN_PROPERTY_CONSTRUCTOR);
            this.supportedMethods.add("hasOwnProperty");
            this.supportedMethods.add("isPrototypeOf");
            this.supportedMethods.add("propertyIsEnumerable");
            this.supportedMethods.add("toLocaleString");
            this.supportedMethods.add("toString");
            this.supportedMethods.add("valueOf");
            if (ContainerValue.isNumber(value)) {
                this.supportedMethods.add("isNaN");
                this.supportedMethods.add("isFinite");
                this.supportedMethods.add("isInteger");
                this.supportedMethods.add("isSafeInteger");
                this.supportedMethods.add("parseFloat");
                this.supportedMethods.add("parseInt");
                this.supportedMethods.add("toExponential");
                this.supportedMethods.add("toFixed");
                this.supportedMethods.add("toPrecision");
            }
            if (ContainerValue.isString(value)) {
                this.builtinProperties.add(UniversalContainer.BUILTIN_PROPERTY_LENGTH);
                this.supportedMethods.add("fromCharCode");
                this.supportedMethods.add("charAt");
                this.supportedMethods.add("charCodeAt");
                this.supportedMethods.add("codePointAt");
                this.supportedMethods.add("concat");
                this.supportedMethods.add("includes");
                this.supportedMethods.add("endsWith");
                this.supportedMethods.add("indexOf");
                this.supportedMethods.add("lastIndexOf");
                this.supportedMethods.add("localeCompare");
                this.supportedMethods.add("match");
                this.supportedMethods.add("normalize");
                this.supportedMethods.add("repeat");
                this.supportedMethods.add("replace");
                this.supportedMethods.add("search");
                this.supportedMethods.add("slice");
                this.supportedMethods.add("split");
                this.supportedMethods.add("startsWith");
                this.supportedMethods.add("substr");
                this.supportedMethods.add("substring");
                this.supportedMethods.add("toLocaleLowerCase");
                this.supportedMethods.add("toLocaleUpperCase");
                this.supportedMethods.add("toLowerCase");
                this.supportedMethods.add("toUpperCase");
                this.supportedMethods.add("trim");
                this.supportedMethods.add("anchor");
                this.supportedMethods.add("link");
            }
        }

        @Override
        public String getClassName() {
            if (ContainerValue.isBoolean(this.literal)) {
                return UniversalContainer.BUILTIN_CLASS_BOOLEAN;
            }
            if (ContainerValue.isNumber(this.literal)) {
                return UniversalContainer.BUILTIN_CLASS_NUMBER;
            }
            if (ContainerValue.isString(this.literal)) {
                return UniversalContainer.BUILTIN_CLASS_STRING;
            }
            return UniversalContainer.BUILTIN_CLASS_LITERAL;
        }

        @Override
        public String getType() {
            if (ContainerValue.isBoolean(this.literal)) {
                return UniversalContainer.BUILTIN_TYPE_BOOLEAN;
            }
            if (ContainerValue.isNumber(this.literal)) {
                return UniversalContainer.BUILTIN_TYPE_NUMBER;
            }
            if (ContainerValue.isString(this.literal)) {
                return UniversalContainer.BUILTIN_TYPE_STRING;
            }
            return UniversalContainer.BUILTIN_TYPE_UNKNOWN;
        }
    }

    protected static class NullValue
    extends ContainerValue {
        public NullValue() {
            this.supportedMethods.add("create");
        }

        @Override
        public String getClassName() {
            return UniversalContainer.BUILTIN_CLASS_NULL;
        }

        @Override
        public String getType() {
            return UniversalContainer.BUILTIN_TYPE_NULL;
        }
    }

    protected static class UndefinedValue
    extends ContainerValue {
        protected UndefinedValue() {
        }

        @Override
        public String getClassName() {
            return UniversalContainer.BUILTIN_CLASS_UNDEFINED;
        }

        @Override
        public String getType() {
            return UniversalContainer.BUILTIN_TYPE_UNDEFINED;
        }
    }

    protected static abstract class ContainerValue {
        public Object literal = null;
        public Map<String, UniversalContainer> table = null;
        public Set<String> builtinProperties = new HashSet<String>();
        public Set<String> supportedMethods = new HashSet<String>();

        protected ContainerValue() {
        }

        public abstract String getClassName();

        public abstract String getType();

        public static boolean isString(Object value) {
            return value instanceof String || value instanceof PrimitiveLiteralValue && ((PrimitiveLiteralValue)value).literal instanceof String || value instanceof UniversalContainer && ((UniversalContainer)value).inner.literal instanceof String;
        }

        public static boolean isNumber(Object value) {
            return value instanceof Number || value instanceof PrimitiveLiteralValue && ((PrimitiveLiteralValue)value).literal instanceof Number || value instanceof UniversalContainer && ((UniversalContainer)value).inner.literal instanceof Number;
        }

        public static boolean isBoolean(Object value) {
            return value instanceof Boolean || value instanceof PrimitiveLiteralValue && ((PrimitiveLiteralValue)value).literal instanceof Boolean || value instanceof UniversalContainer && ((UniversalContainer)value).inner.literal instanceof Boolean;
        }

        public static boolean asBoolean(Object value) {
            if (ContainerValue.isBoolean(value)) {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                if (value instanceof PrimitiveLiteralValue && ((PrimitiveLiteralValue)value).literal instanceof Boolean) {
                    return (Boolean)((PrimitiveLiteralValue)value).literal;
                }
                if (value instanceof UniversalContainer && ((UniversalContainer)value).inner.literal instanceof Boolean) {
                    return (Boolean)((UniversalContainer)value).inner.literal;
                }
            } else if (ContainerValue.isNumber(value) || ContainerValue.isString(value)) {
                return ContainerValue.asString(value).equals("1");
            }
            return false;
        }

        public static Number asNumber(Object value) {
            if (ContainerValue.isBoolean(value)) {
                return ContainerValue.asBoolean(value) ? 1 : 0;
            }
            if (ContainerValue.isNumber(value)) {
                if (value instanceof Number) {
                    return (Number)value;
                }
                if (value instanceof PrimitiveLiteralValue && ((PrimitiveLiteralValue)value).literal instanceof Number) {
                    return (Number)((PrimitiveLiteralValue)value).literal;
                }
                if (value instanceof UniversalContainer && ((UniversalContainer)value).inner.literal instanceof Number) {
                    return (Number)((UniversalContainer)value).inner.literal;
                }
            } else if (ContainerValue.isString(value) && NumberUtils.isParsable((String)ContainerValue.asString(value))) {
                return Double.parseDouble(ContainerValue.asString(value));
            }
            return 0;
        }

        public static String asString(Object value) {
            String s;
            Object literal = value;
            if (value instanceof PrimitiveLiteralValue) {
                literal = ((PrimitiveLiteralValue)value).literal;
            } else if (value instanceof ContainerValue) {
                literal = null;
            } else if (value instanceof UniversalContainer && ((UniversalContainer)value).inner instanceof PrimitiveLiteralValue) {
                literal = ((UniversalContainer)value).inner.literal;
            } else if (value instanceof UniversalContainer) {
                literal = null;
            }
            String string = s = literal != null ? literal.toString() : "";
            if (ContainerValue.isNumber(value) && s.endsWith(".0")) {
                return s.replaceFirst(".0", "");
            }
            return s;
        }

        public boolean isPropertyExists(String property) {
            return this.builtinProperties.contains(property) && !property.equals(UniversalContainer.BUILTIN_PROPERTY_CONSTRUCTOR) || this.table != null && this.table.containsKey(property);
        }

        public boolean isMethodSupported(String method) {
            return this.supportedMethods.contains(method);
        }

        public String toString() {
            if (this.table != null) {
                return this.table.toString();
            }
            if (this.literal != null) {
                return this.literal.toString();
            }
            return this.getType();
        }
    }
}

