/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Constants;
import org.apache.tomcat.util.net.DefaultServerSocketFactory;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class JIoEndpoint
extends AbstractEndpoint {
    private static final Log log = LogFactory.getLog(JIoEndpoint.class);
    protected ServerSocket serverSocket = null;
    protected int acceptorThreadCount = 0;
    protected Handler handler = null;
    protected ServerSocketFactory serverSocketFactory = null;
    protected ConcurrentLinkedQueue<SocketWrapper<Socket>> waitingRequests = new ConcurrentLinkedQueue();

    public JIoEndpoint() {
        this.setMaxConnections(0);
    }

    public void setAcceptorThreadCount(int acceptorThreadCount) {
        this.acceptorThreadCount = acceptorThreadCount;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.serverSocketFactory = factory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    @Override
    public boolean getUseSendfile() {
        return false;
    }

    @Override
    public boolean getUseComet() {
        return false;
    }

    @Override
    public boolean getUseCometTimeout() {
        return false;
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    @Override
    public boolean getUsePolling() {
        return false;
    }

    @Override
    public void bind() throws Exception {
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.getMaxConnections() == 0) {
            this.setMaxConnections(this.getMaxThreads());
        }
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = this.isSSLEnabled() ? this.handler.getSslImplementation().getServerSocketFactory(this) : new DefaultServerSocketFactory(this);
        }
        if (this.serverSocket == null) {
            try {
                this.serverSocket = this.getAddress() == null ? this.serverSocketFactory.createSocket(this.getPort(), this.getBacklog()) : this.serverSocketFactory.createSocket(this.getPort(), this.getBacklog(), this.getAddress());
            }
            catch (BindException orig) {
                String msg = this.getAddress() == null ? orig.getMessage() + " <null>:" + this.getPort() : orig.getMessage() + " " + this.getAddress().toString() + ":" + this.getPort();
                BindException be = new BindException(msg);
                be.initCause(orig);
                throw be;
            }
        }
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.running = true;
            this.paused = false;
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            for (int i = 0; i < this.acceptorThreadCount; ++i) {
                Thread acceptorThread = new Thread((Runnable)new Acceptor(), this.getName() + "-Acceptor-" + i);
                acceptorThread.setPriority(this.threadPriority);
                acceptorThread.setDaemon(this.getDaemon());
                acceptorThread.start();
            }
            Thread timeoutThread = new Thread((Runnable)new AsyncTimeout(), this.getName() + "-AsyncTimeout");
            timeoutThread.setPriority(this.threadPriority);
            timeoutThread.setDaemon(true);
            timeoutThread.start();
        }
    }

    @Override
    public void stopInternal() {
        this.releaseConnectionLatch();
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.unlockAccept();
        }
        this.shutdownExecutor();
    }

    @Override
    public void unbind() throws Exception {
        if (this.running) {
            this.stop();
        }
        if (this.serverSocket != null) {
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Exception e) {
                log.error(sm.getString("endpoint.err.close"), e);
            }
            this.serverSocket = null;
        }
        this.handler.recycle();
    }

    protected boolean setSocketOptions(Socket socket) {
        try {
            this.socketProperties.setProperties(socket);
        }
        catch (SocketException s) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("endpoint.err.unexpected"), s);
            }
            return false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error(sm.getString("endpoint.err.unexpected"), t);
            return false;
        }
        return true;
    }

    protected boolean processSocket(Socket socket) {
        try {
            SocketWrapper<Socket> wrapper = new SocketWrapper<Socket>(socket);
            wrapper.setKeepAliveLeft(this.getMaxKeepAliveRequests());
            if (!this.running) {
                return false;
            }
            this.getExecutor().execute(new SocketProcessor(wrapper));
        }
        catch (RejectedExecutionException x) {
            log.warn("Socket processing request was rejected for:" + socket, x);
            return false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error(sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processSocketAsync(SocketWrapper<Socket> socket, SocketStatus status) {
        try {
            SocketWrapper<Socket> socketWrapper = socket;
            synchronized (socketWrapper) {
                if (!this.waitingRequests.remove(socket)) return true;
                SocketProcessor proc = new SocketProcessor(socket, status);
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    if (Constants.IS_SECURITY_ENABLED) {
                        PrivilegedSetTccl pa = new PrivilegedSetTccl(this.getClass().getClassLoader());
                        AccessController.doPrivileged(pa);
                    } else {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    }
                    if (!this.running) {
                        boolean pa = false;
                        return pa;
                    }
                    this.getExecutor().execute(proc);
                }
                finally {
                    if (Constants.IS_SECURITY_ENABLED) {
                        PrivilegedSetTccl pa = new PrivilegedSetTccl(loader);
                        AccessController.doPrivileged(pa);
                    } else {
                        Thread.currentThread().setContextClassLoader(loader);
                    }
                }
                return true;
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error(sm.getString("endpoint.process.fail"), t);
            return false;
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private static class PrivilegedSetTccl
    implements PrivilegedAction<Void> {
        private ClassLoader cl;

        PrivilegedSetTccl(ClassLoader cl) {
            this.cl = cl;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.cl);
            return null;
        }
    }

    protected class SocketProcessor
    implements Runnable {
        protected SocketWrapper<Socket> socket = null;
        protected SocketStatus status = null;

        public SocketProcessor(SocketWrapper<Socket> socket) {
            if (socket == null) {
                throw new NullPointerException();
            }
            this.socket = socket;
        }

        public SocketProcessor(SocketWrapper<Socket> socket, SocketStatus status) {
            this(socket);
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean launch = false;
            SocketWrapper<Socket> socketWrapper = this.socket;
            synchronized (socketWrapper) {
                try {
                    AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.OPEN;
                    try {
                        JIoEndpoint.this.serverSocketFactory.handshake(this.socket.getSocket());
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                        if (log.isDebugEnabled()) {
                            log.debug(AbstractEndpoint.sm.getString("endpoint.err.handshake"), t);
                        }
                        state = AbstractEndpoint.Handler.SocketState.CLOSED;
                    }
                    if (state != AbstractEndpoint.Handler.SocketState.CLOSED) {
                        state = this.status == null ? JIoEndpoint.this.handler.process(this.socket, SocketStatus.OPEN) : JIoEndpoint.this.handler.process(this.socket, this.status);
                    }
                    if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        if (log.isTraceEnabled()) {
                            log.trace("Closing socket:" + this.socket);
                        }
                        JIoEndpoint.this.countDownConnection();
                        try {
                            this.socket.getSocket().close();
                        }
                        catch (IOException e) {}
                    } else if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                        this.socket.setKeptAlive(true);
                        this.socket.access();
                        launch = true;
                    } else if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                        this.socket.access();
                        JIoEndpoint.this.waitingRequests.add(this.socket);
                    }
                }
                finally {
                    block24: {
                        if (launch) {
                            try {
                                JIoEndpoint.this.getExecutor().execute(new SocketProcessor(this.socket, SocketStatus.OPEN));
                            }
                            catch (NullPointerException npe) {
                                if (!JIoEndpoint.this.running) break block24;
                                log.error(AbstractEndpoint.sm.getString("endpoint.launch.fail"), npe);
                            }
                        }
                    }
                }
            }
            this.socket = null;
        }
    }

    protected class Acceptor
    implements Runnable {
        protected Acceptor() {
        }

        @Override
        public void run() {
            int errorDelay = 0;
            while (JIoEndpoint.this.running) {
                while (JIoEndpoint.this.paused && JIoEndpoint.this.running) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                if (!JIoEndpoint.this.running) break;
                try {
                    JIoEndpoint.this.countUpOrAwaitConnection();
                    Socket socket = null;
                    try {
                        socket = JIoEndpoint.this.serverSocketFactory.acceptSocket(JIoEndpoint.this.serverSocket);
                    }
                    catch (IOException ioe) {
                        errorDelay = JIoEndpoint.this.handleExceptionWithDelay(errorDelay);
                        throw ioe;
                    }
                    errorDelay = 0;
                    if (JIoEndpoint.this.setSocketOptions(socket)) {
                        if (JIoEndpoint.this.processSocket(socket)) continue;
                        try {
                            socket.close();
                        }
                        catch (IOException e) {}
                        continue;
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException x) {
                    if (!JIoEndpoint.this.running) continue;
                    log.error(AbstractEndpoint.sm.getString("endpoint.accept.fail"), x);
                }
                catch (NullPointerException npe) {
                    if (!JIoEndpoint.this.running) continue;
                    log.error(AbstractEndpoint.sm.getString("endpoint.accept.fail"), npe);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    log.error(AbstractEndpoint.sm.getString("endpoint.accept.fail"), t);
                }
            }
        }
    }

    protected class AsyncTimeout
    implements Runnable {
        protected AsyncTimeout() {
        }

        @Override
        public void run() {
            while (JIoEndpoint.this.running) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long now = System.currentTimeMillis();
                for (SocketWrapper<Socket> socket : JIoEndpoint.this.waitingRequests) {
                    long access = socket.getLastAccess();
                    if (socket.getTimeout() <= 0L || now - access <= socket.getTimeout()) continue;
                    JIoEndpoint.this.processSocketAsync(socket, SocketStatus.TIMEOUT);
                }
                while (JIoEndpoint.this.paused && JIoEndpoint.this.running) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    public static interface Handler
    extends AbstractEndpoint.Handler {
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> var1, SocketStatus var2);

        public SSLImplementation getSslImplementation();
    }
}

