/*
 * Decompiled with CFR 0.152.
 */
package webapp.runner.launch;

import java.io.File;
import java.util.Map;
import org.apache.catalina.Context;
import org.apache.catalina.startup.Tomcat;
import webapp.runner.launch.ArgParser;
import webapp.runner.launch.Argument;
import webapp.runner.launch.ArgumentNotFoundException;
import webapp.runner.launch.MissingAppException;

public class Main {
    public static void printHelp() {
        System.out.println("Tomcat Runner runs a Java web application that is represented as an exploded war in a Tomcat container");
        System.out.println("Usage: java -jar tomcat-runner.jar [arguments...] path/to/webapp");
        System.out.println("Arguments:");
        for (Argument argument : Argument.values()) {
            System.out.format("%-30s%-90s%n", argument.argName(), argument.helpText());
        }
    }

    public static void main(String[] args) throws Exception {
        String path;
        if (args.length == 0 || "help".equals(args[0]) || "--help".equals(args[0])) {
            Main.printHelp();
            System.exit(0);
        }
        Map<Argument, String> argMap = null;
        try {
            argMap = ArgParser.parseArgs(args);
        }
        catch (ArgumentNotFoundException e) {
            System.out.println("Unexpected Argument: " + e.getArgName());
            System.out.println("For usage information run `java -jar tomcat-runner.jar help`");
            System.exit(1);
        }
        catch (MissingAppException e) {
            System.out.println("Application location not defined");
            System.out.println("For usage information run `java -jar tomcat-runner.jar help`");
            System.exit(1);
        }
        Tomcat tomcat = new Tomcat();
        String webPort = argMap.containsKey((Object)Argument.PORT) ? argMap.get((Object)Argument.PORT) : "8080";
        tomcat.setPort(Integer.valueOf(webPort));
        String string = path = argMap.containsKey((Object)Argument.PATH) ? argMap.get((Object)Argument.PATH) : "";
        if (path.length() > 0 && !path.startsWith("/")) {
            System.out.println("WARNING: you entered a path: [" + path + "]. Your path should start with a '/'. Tomcat will update this for you, but you may still experience issues.");
        }
        Context ctx = tomcat.addWebapp(path, new File(argMap.get((Object)Argument.APPLICATION_DIR)).getAbsolutePath());
        if (argMap.containsKey((Object)Argument.SESSION_TIMEOUT)) {
            ctx.setSessionTimeout(Integer.valueOf(argMap.get((Object)Argument.SESSION_TIMEOUT)));
        }
        System.out.println("deploying app from: " + new File(argMap.get((Object)Argument.APPLICATION_DIR)).getAbsolutePath());
        tomcat.start();
        tomcat.getServer().await();
    }
}

