/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.vbucket.provider;

import com.couchbase.client.CouchbaseConnection;
import com.couchbase.client.CouchbaseConnectionFactory;
import com.couchbase.client.CouchbaseProperties;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.BroadcastOpFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.FailureMode;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.compat.log.Level;
import net.spy.memcached.compat.log.Logger;
import net.spy.memcached.compat.log.LoggerFactory;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;

public class CouchbaseConfigConnection
extends CouchbaseConnection {
    private static final String DEFAULT_MISSED_NOOPS_THRESHOLD = "3";
    private final short noopsThreshold = Short.decode(CouchbaseProperties.getProperty("configPollThreshold", "3"));
    private volatile short outstandingNoops = 0;
    private static final Logger LOGGER = new LoggerProxy(LoggerFactory.getLogger(CouchbaseConfigConnection.class));

    public CouchbaseConfigConnection(int bufSize, CouchbaseConnectionFactory f, List<InetSocketAddress> a, Collection<ConnectionObserver> obs, FailureMode fm, OperationFactory opfactory) throws IOException {
        super(bufSize, f, a, obs, fm, opfactory);
        LOGGER.debug("Using config noop threshold of " + this.noopsThreshold);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{CouchbaseConfigConnection to");
        for (MemcachedNode qa : this.locator.getAll()) {
            sb.append(" ").append(qa.getSocketAddress());
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    protected void handleWokenUpSelector() {
        long now = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime());
        long diff = now - this.lastWrite;
        if (this.lastWrite > 0L && diff >= 5L) {
            if (this.outstandingNoops >= this.noopsThreshold) {
                this.cf.getConfigurationProvider().signalOutdated();
                this.outstandingNoops = 0;
            }
            this.updateLastWrite();
            this.getLogger().debug("Wakeup counter triggered, broadcasting noops.");
            final OperationFactory fact = this.cf.getOperationFactory();
            this.outstandingNoops = (short)(this.outstandingNoops + 1);
            this.broadcastOperation(new BroadcastOpFactory(){

                @Override
                public Operation newOp(MemcachedNode n, CountDownLatch latch) {
                    return fact.noop(new OperationCallback(){

                        @Override
                        public void receivedStatus(OperationStatus status) {
                            if (status.isSuccess() && CouchbaseConfigConnection.this.outstandingNoops > 0) {
                                CouchbaseConfigConnection.access$010(CouchbaseConfigConnection.this);
                            }
                        }

                        @Override
                        public void complete() {
                        }
                    });
                }
            });
        }
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    static /* synthetic */ short access$010(CouchbaseConfigConnection x0) {
        short s = x0.outstandingNoops;
        x0.outstandingNoops = (short)(s - 1);
        return s;
    }

    public static class LoggerProxy
    implements Logger {
        private final Logger logger;

        public LoggerProxy(Logger logger) {
            this.logger = logger;
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public void log(Level level, Object o, Throwable throwable) {
            this.logger.log(Level.DEBUG, o, throwable);
        }

        @Override
        public void log(Level level, Object o) {
            this.logger.log(Level.DEBUG, o);
        }

        @Override
        public void trace(Object o, Throwable throwable) {
            this.logger.trace(o, throwable);
        }

        @Override
        public void trace(Object o) {
            this.logger.trace(o);
        }

        @Override
        public void trace(String s, Object ... objects) {
            this.logger.trace(s, objects);
        }

        @Override
        public void debug(Object o, Throwable throwable) {
            this.logger.debug(o, throwable);
        }

        @Override
        public void debug(Object o) {
            this.logger.debug(o);
        }

        @Override
        public void debug(String s, Object ... objects) {
            this.logger.debug(s, objects);
        }

        @Override
        public void info(Object o, Throwable throwable) {
            this.logger.debug(o, throwable);
        }

        @Override
        public void info(Object o) {
            this.logger.debug(o);
        }

        @Override
        public void info(String s, Object ... objects) {
            this.logger.debug(s, objects);
        }

        @Override
        public void warn(Object o, Throwable throwable) {
            this.logger.debug(o, throwable);
        }

        @Override
        public void warn(Object o) {
            this.logger.debug(o);
        }

        @Override
        public void warn(String s, Object ... objects) {
            this.logger.debug(s, objects);
        }

        @Override
        public void error(Object o, Throwable throwable) {
            this.logger.debug(o, throwable);
        }

        @Override
        public void error(Object o) {
            this.logger.debug(o);
        }

        @Override
        public void error(String s, Object ... objects) {
            this.logger.debug(s, objects);
        }

        @Override
        public void fatal(Object o, Throwable throwable) {
            this.logger.debug(o, throwable);
        }

        @Override
        public void fatal(Object o) {
            this.logger.debug(o);
        }

        @Override
        public void fatal(String s, Object ... objects) {
            this.logger.debug(s, objects);
        }
    }
}

