/*
 * Decompiled with CFR 0.152.
 */
package ru.zinin.redis.session;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import ru.zinin.redis.session.RedisHttpSession;
import ru.zinin.redis.session.RedisSessionKeys;

public class RedisSessionTemplate {
    private JedisPool jedisPool;
    private ServletContext servletContext;
    private boolean disableListeners = false;

    public RedisSessionTemplate() {
    }

    public RedisSessionTemplate(JedisPool jedisPool, ServletContext servletContext) {
        this.jedisPool = jedisPool;
        this.servletContext = servletContext;
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public boolean isDisableListeners() {
        return this.disableListeners;
    }

    public void setDisableListeners(boolean disableListeners) {
        this.disableListeners = disableListeners;
    }

    private void verifyInitialization() {
        if (this.jedisPool == null) {
            throw new IllegalStateException("JedisPool is not initialized");
        }
        if (this.servletContext == null) {
            throw new IllegalStateException("ServletContext is not initialized");
        }
    }

    public Set<RedisHttpSession> getAllSessions() {
        Set<String> sessionIds;
        this.verifyInitialization();
        Jedis jedis = this.jedisPool.getResource();
        try {
            sessionIds = jedis.zrangeByScore(RedisSessionKeys.getSessionsKey(), 0.0, Double.MAX_VALUE);
            this.jedisPool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.jedisPool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        HashSet<RedisHttpSession> result = new HashSet<RedisHttpSession>(sessionIds.size());
        for (String sessionId : sessionIds) {
            RedisHttpSession session = new RedisHttpSession(sessionId, this.jedisPool, this.servletContext, this.disableListeners);
            if (!session.isValid()) continue;
            result.add(session);
        }
        return result;
    }

    public RedisHttpSession getSession(String id) {
        this.verifyInitialization();
        return new RedisHttpSession(id, this.jedisPool, this.servletContext, this.disableListeners);
    }
}

