/*
 * Decompiled with CFR 0.152.
 */
package ru.zinin.redis.session;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import ru.zinin.redis.session.RedisHttpSession;
import ru.zinin.redis.session.RedisManager;
import ru.zinin.redis.session.RedisSessionKeys;
import ru.zinin.redis.session.event.RedisSessionAddAttributeEvent;
import ru.zinin.redis.session.event.RedisSessionCreatedEvent;
import ru.zinin.redis.session.event.RedisSessionDestroyedEvent;
import ru.zinin.redis.session.event.RedisSessionEvent;
import ru.zinin.redis.session.event.RedisSessionRemoveAttributeEvent;
import ru.zinin.redis.session.event.RedisSessionReplaceAttributeEvent;
import ru.zinin.redis.util.Base64Util;
import ru.zinin.redis.util.RedisSerializationUtil;

public class RedisEventListenerThread
implements Runnable {
    private final Log log = LogFactory.getLog(RedisEventListenerThread.class);
    private static final StringManager sm = StringManager.getManager("ru.zinin.redis.session");
    private RedisManager manager;
    private AtomicBoolean stopFlag = new AtomicBoolean(false);
    private JedisPubSub pubSub = new JedisPubSub(){

        @Override
        public void onMessage(String channel, String message) {
            byte[] bytes = Base64Util.decode(message);
            RedisSessionEvent event = (RedisSessionEvent)RedisSerializationUtil.decode(bytes);
            RedisEventListenerThread.this.log.debug("Event from " + channel + ": " + event);
            if (event instanceof RedisSessionCreatedEvent) {
                RedisEventListenerThread.this.sessionCreatedEvent((RedisSessionCreatedEvent)event);
            } else if (event instanceof RedisSessionDestroyedEvent) {
                RedisEventListenerThread.this.sessionDestroyedEvent((RedisSessionDestroyedEvent)event);
            } else if (event instanceof RedisSessionAddAttributeEvent) {
                RedisEventListenerThread.this.sessionAttributeAddEvent((RedisSessionAddAttributeEvent)event);
            } else if (event instanceof RedisSessionRemoveAttributeEvent) {
                RedisEventListenerThread.this.sessionAttributeRemoveEvent((RedisSessionRemoveAttributeEvent)event);
            } else if (event instanceof RedisSessionReplaceAttributeEvent) {
                RedisEventListenerThread.this.sessionAttributeReplaceEvent((RedisSessionReplaceAttributeEvent)event);
            }
        }

        @Override
        public void onPMessage(String pattern, String channel, String message) {
            RedisEventListenerThread.this.log.debug("PMessage " + pattern + " from " + channel + ": " + message);
        }

        @Override
        public void onSubscribe(String channel, int subscribedChannels) {
            RedisEventListenerThread.this.log.debug("Subscribe: " + channel + "; count: " + subscribedChannels);
        }

        @Override
        public void onUnsubscribe(String channel, int subscribedChannels) {
            RedisEventListenerThread.this.log.debug("Unsubscribe: " + channel + "; count: " + subscribedChannels);
        }

        @Override
        public void onPUnsubscribe(String pattern, int subscribedChannels) {
            RedisEventListenerThread.this.log.debug("PUnsubscribe: " + pattern + "; count: " + subscribedChannels);
        }

        @Override
        public void onPSubscribe(String pattern, int subscribedChannels) {
            RedisEventListenerThread.this.log.debug("PSubscribe: " + pattern + "; count: " + subscribedChannels);
        }
    };

    public RedisEventListenerThread(RedisManager manager) {
        this.manager = manager;
    }

    @Override
    public void run() {
        while (!this.stopFlag.get()) {
            Jedis jedis = this.manager.getPool().getResource();
            try {
                this.log.debug("Subscribed to " + RedisSessionKeys.getSessionChannel());
                jedis.subscribe(this.pubSub, RedisSessionKeys.getSessionChannel());
                this.log.debug("Done.");
                this.manager.getPool().returnResource(jedis);
            }
            catch (Throwable e) {
                this.manager.getPool().returnBrokenResource(jedis);
                this.log.error(e.getMessage(), e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    this.log.error(e.getMessage(), e);
                }
            }
        }
        this.log.debug("Exiting from listener thread...");
    }

    public void stop() {
        this.stopFlag.set(true);
        this.pubSub.unsubscribe();
    }

    private void fireContainerEvent(Context context, String type, Object data) throws Exception {
        if (context instanceof StandardContext) {
            context.fireContainerEvent(type, data);
        }
    }

    private void sessionCreatedEvent(RedisSessionCreatedEvent sessionCreatedEvent) {
        Context context = this.manager.getContext();
        Object[] listeners = context.getApplicationLifecycleListeners();
        if (listeners != null) {
            RedisHttpSession session = new RedisHttpSession(sessionCreatedEvent.getId(), this.manager);
            HttpSessionEvent event = new HttpSessionEvent(session);
            for (int i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof HttpSessionListener)) continue;
                HttpSessionListener listener = (HttpSessionListener)listeners[i];
                try {
                    this.fireContainerEvent(context, "beforeSessionCreated", listener);
                    listener.sessionCreated(event);
                    this.fireContainerEvent(context, "afterSessionCreated", listener);
                    continue;
                }
                catch (Throwable t) {
                    this.handleThrowable(t);
                    try {
                        this.fireContainerEvent(context, "afterSessionCreated", listener);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.manager.getContext().getLogger().error(sm.getString("standardSession.sessionEvent"), t);
                }
            }
        }
    }

    private void sessionDestroyedEvent(RedisSessionDestroyedEvent sessionDestroyedEvent) {
        Context context = this.manager.getContext();
        Object[] listeners = context.getApplicationLifecycleListeners();
        if (listeners != null) {
            RedisHttpSession session = new RedisHttpSession(sessionDestroyedEvent.getId(), this.manager);
            HttpSessionEvent event = new HttpSessionEvent(session);
            for (int i = 0; i < listeners.length; ++i) {
                int j = listeners.length - 1 - i;
                if (!(listeners[j] instanceof HttpSessionListener)) continue;
                HttpSessionListener listener = (HttpSessionListener)listeners[j];
                try {
                    this.fireContainerEvent(context, "beforeSessionDestroyed", listener);
                    listener.sessionDestroyed(event);
                    this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                    continue;
                }
                catch (Throwable t) {
                    this.handleThrowable(t);
                    try {
                        this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.manager.getContext().getLogger().error(sm.getString("standardSession.sessionEvent"), t);
                }
            }
        }
    }

    private void sessionAttributeAddEvent(RedisSessionAddAttributeEvent sessionAddAttributeEvent) {
        Context context = this.manager.getContext();
        Object[] listeners = context.getApplicationEventListeners();
        if (listeners != null) {
            RedisHttpSession session = new RedisHttpSession(sessionAddAttributeEvent.getId(), this.manager);
            for (int i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
                HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
                try {
                    this.fireContainerEvent(context, "beforeSessionAttributeAdded", listener);
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent(session, sessionAddAttributeEvent.getName(), sessionAddAttributeEvent.getValue());
                    listener.attributeAdded(event);
                    this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                    continue;
                }
                catch (Throwable t) {
                    this.handleThrowable(t);
                    try {
                        this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.manager.getContext().getLogger().error(sm.getString("standardSession.attributeEvent"), t);
                }
            }
        }
    }

    private void sessionAttributeRemoveEvent(RedisSessionRemoveAttributeEvent sessionRemoveAttributeEvent) {
        Context context = this.manager.getContext();
        Object[] listeners = context.getApplicationEventListeners();
        if (listeners != null) {
            RedisHttpSession session = new RedisHttpSession(sessionRemoveAttributeEvent.getId(), this.manager);
            for (int i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
                HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
                try {
                    this.fireContainerEvent(context, "beforeSessionAttributeRemoved", listener);
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent(session, sessionRemoveAttributeEvent.getName(), sessionRemoveAttributeEvent.getValue());
                    listener.attributeRemoved(event);
                    this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                    continue;
                }
                catch (Throwable t) {
                    this.handleThrowable(t);
                    try {
                        this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.manager.getContext().getLogger().error(sm.getString("standardSession.attributeEvent"), t);
                }
            }
        }
    }

    private void sessionAttributeReplaceEvent(RedisSessionReplaceAttributeEvent sessionReplaceAttributeEvent) {
        Context context = this.manager.getContext();
        Object[] listeners = context.getApplicationEventListeners();
        if (listeners != null) {
            RedisHttpSession session = new RedisHttpSession(sessionReplaceAttributeEvent.getId(), this.manager);
            for (int i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
                HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
                try {
                    this.fireContainerEvent(context, "beforeSessionAttributeReplaced", listener);
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent(session, sessionReplaceAttributeEvent.getName(), sessionReplaceAttributeEvent.getValue());
                    listener.attributeReplaced(event);
                    this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                    continue;
                }
                catch (Throwable t) {
                    this.handleThrowable(t);
                    try {
                        this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.manager.getContext().getLogger().error(sm.getString("standardSession.attributeEvent"), t);
                }
            }
        }
    }

    private void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
    }
}

