/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.Serializable;
import org.redisson.RedissonAtomicLong;
import org.redisson.RedissonBitSet;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonBucket;
import org.redisson.RedissonDeque;
import org.redisson.RedissonHyperLogLog;
import org.redisson.RedissonLexSortedSet;
import org.redisson.RedissonList;
import org.redisson.RedissonMap;
import org.redisson.RedissonMapCache;
import org.redisson.RedissonQueue;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonSet;
import org.redisson.RedissonSetCache;
import org.redisson.api.RObject;
import org.redisson.api.RObjectReactive;
import org.redisson.api.annotation.REntity;
import org.redisson.client.codec.Codec;
import org.redisson.liveobject.misc.ClassUtils;
import org.redisson.misc.BiHashMap;
import org.redisson.reactive.RedissonAtomicLongReactive;
import org.redisson.reactive.RedissonBitSetReactive;
import org.redisson.reactive.RedissonBlockingQueueReactive;
import org.redisson.reactive.RedissonBucketReactive;
import org.redisson.reactive.RedissonDequeReactive;
import org.redisson.reactive.RedissonHyperLogLogReactive;
import org.redisson.reactive.RedissonLexSortedSetReactive;
import org.redisson.reactive.RedissonListReactive;
import org.redisson.reactive.RedissonMapCacheReactive;
import org.redisson.reactive.RedissonMapReactive;
import org.redisson.reactive.RedissonQueueReactive;
import org.redisson.reactive.RedissonScoredSortedSetReactive;
import org.redisson.reactive.RedissonSetCacheReactive;
import org.redisson.reactive.RedissonSetReactive;

public class RedissonReference
implements Serializable {
    private static final BiHashMap<String, String> reactiveMap = new BiHashMap();
    private String type;
    private String keyName;
    private String codec;

    public static void warmUp() {
    }

    public RedissonReference() {
    }

    public RedissonReference(Class type, String keyName) {
        this(type, keyName, null);
    }

    public RedissonReference(Class type, String keyName, Codec codec) {
        if (!(ClassUtils.isAnnotationPresent(type, REntity.class) || RObject.class.isAssignableFrom(type) || RObjectReactive.class.isAssignableFrom(type))) {
            throw new IllegalArgumentException("Class reference has to be a type of either RObject or RLiveObject or RObjectReactive");
        }
        this.type = RObjectReactive.class.isAssignableFrom(type) ? reactiveMap.get(type.getName()) : type.getName();
        this.keyName = keyName;
        this.codec = codec != null ? codec.getClass().getName() : null;
    }

    public Class<?> getType() throws Exception {
        return Class.forName(this.type);
    }

    public Class<?> getReactiveType() throws Exception {
        if (reactiveMap.containsValue(this.type)) {
            return Class.forName(reactiveMap.reverseGet(this.type));
        }
        throw new ClassNotFoundException("There is no Reactive compatible type for " + this.type);
    }

    public String getTypeName() {
        return this.type;
    }

    public String getReactiveTypeName() {
        return this.type + "Reactive";
    }

    public void setType(Class<?> type) {
        if (!(ClassUtils.isAnnotationPresent(type, REntity.class) || RObject.class.isAssignableFrom(type) && RObjectReactive.class.isAssignableFrom(type))) {
            throw new IllegalArgumentException("Class reference has to be a type of either RObject or RLiveObject or RObjectReactive");
        }
        this.type = type.getName();
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getCodec() {
        return this.codec;
    }

    public Class<? extends Codec> getCodecType() throws Exception {
        return this.codec == null ? null : Class.forName(this.codec);
    }

    public String getCodecName() {
        return this.codec;
    }

    public void setCodecType(Class<? extends Codec> codec) {
        this.codec = codec.getName();
    }

    static {
        reactiveMap.put(RedissonAtomicLongReactive.class.getName(), RedissonAtomicLong.class.getName());
        reactiveMap.put(RedissonBitSetReactive.class.getName(), RedissonBitSet.class.getName());
        reactiveMap.put(RedissonBlockingQueueReactive.class.getName(), RedissonBlockingQueue.class.getName());
        reactiveMap.put(RedissonBucketReactive.class.getName(), RedissonBucket.class.getName());
        reactiveMap.put(RedissonDequeReactive.class.getName(), RedissonDeque.class.getName());
        reactiveMap.put(RedissonHyperLogLogReactive.class.getName(), RedissonHyperLogLog.class.getName());
        reactiveMap.put(RedissonLexSortedSetReactive.class.getName(), RedissonLexSortedSet.class.getName());
        reactiveMap.put(RedissonListReactive.class.getName(), RedissonList.class.getName());
        reactiveMap.put(RedissonMapCacheReactive.class.getName(), RedissonMapCache.class.getName());
        reactiveMap.put(RedissonMapReactive.class.getName(), RedissonMap.class.getName());
        reactiveMap.put(RedissonQueueReactive.class.getName(), RedissonQueue.class.getName());
        reactiveMap.put(RedissonScoredSortedSetReactive.class.getName(), RedissonScoredSortedSet.class.getName());
        reactiveMap.put(RedissonSetCacheReactive.class.getName(), RedissonSetCache.class.getName());
        reactiveMap.put(RedissonSetReactive.class.getName(), RedissonSet.class.getName());
        reactiveMap.makeImmutable();
    }
}

