/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.session.ManagerBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.redisson.Redisson;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.config.Config;
import org.redisson.tomcat.RedissonSession;
import org.redisson.tomcat.UpdateValve;

public class RedissonSessionManager
extends ManagerBase {
    private final Log log = LogFactory.getLog(RedissonSessionManager.class);
    private RedissonClient redisson;
    private String configPath;
    private ReadMode readMode = ReadMode.MEMORY;
    private UpdateMode updateMode = UpdateMode.DEFAULT;
    private String keyPrefix = "";

    public String getUpdateMode() {
        return this.updateMode.toString();
    }

    public void setUpdateMode(String updateMode) {
        this.updateMode = UpdateMode.valueOf(updateMode);
    }

    public String getReadMode() {
        return this.readMode.toString();
    }

    public void setReadMode(String readMode) {
        this.readMode = ReadMode.valueOf(readMode);
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    @Override
    public String getName() {
        return RedissonSessionManager.class.getSimpleName();
    }

    @Override
    public void load() throws ClassNotFoundException, IOException {
    }

    @Override
    public void unload() throws IOException {
    }

    @Override
    public Session createSession(String sessionId) {
        RedissonSession session = (RedissonSession)this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.getContext().getSessionTimeout() * 60);
        if (sessionId == null) {
            sessionId = this.generateSessionId();
        }
        session.setId(sessionId);
        session.save();
        return session;
    }

    public RMap<String, Object> getMap(String sessionId) {
        String separator = this.keyPrefix == null || this.keyPrefix.isEmpty() ? "" : ":";
        return this.redisson.getMap(this.keyPrefix + separator + "redisson_tomcat_session:" + sessionId);
    }

    @Override
    public Session findSession(String id) throws IOException {
        Session result = super.findSession(id);
        if (result == null && id != null) {
            Map<String, Object> attrs = this.getMap(id).readAllMap();
            if (attrs.isEmpty() || !Boolean.valueOf(String.valueOf(attrs.get("session:isValid"))).booleanValue()) {
                this.log.info("Session " + id + " can't be found");
                return null;
            }
            RedissonSession session = (RedissonSession)this.createEmptySession();
            session.setId(id);
            session.load(attrs);
            session.access();
            session.endAccess();
            return session;
        }
        result.access();
        result.endAccess();
        return result;
    }

    @Override
    public Session createEmptySession() {
        return new RedissonSession(this, this.readMode, this.updateMode);
    }

    @Override
    public void remove(Session session, boolean update) {
        super.remove(session, update);
        if (session.getIdInternal() != null) {
            ((RedissonSession)session).delete();
        }
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        super.startInternal();
        this.redisson = this.buildClient();
        if (this.updateMode == UpdateMode.AFTER_REQUEST) {
            this.getEngine().getPipeline().addValve(new UpdateValve(this));
        }
        this.setState(LifecycleState.STARTING);
    }

    protected RedissonClient buildClient() throws LifecycleException {
        Config config = null;
        try {
            config = Config.fromJSON(new File(this.configPath), this.getClass().getClassLoader());
        }
        catch (IOException e) {
            try {
                config = Config.fromYAML(new File(this.configPath), this.getClass().getClassLoader());
            }
            catch (IOException e1) {
                this.log.error("Can't parse json config " + this.configPath, e);
                throw new LifecycleException("Can't parse yaml config " + this.configPath, e1);
            }
        }
        try {
            Config c = new Config(config);
            Codec codec = (Codec)c.getCodec().getClass().getConstructor(ClassLoader.class).newInstance(Thread.currentThread().getContextClassLoader());
            config.setCodec(codec);
            return Redisson.create(config);
        }
        catch (Exception e) {
            throw new LifecycleException(e);
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.setState(LifecycleState.STOPPING);
        try {
            if (this.redisson != null) {
                this.redisson.shutdown();
            }
        }
        catch (Exception e) {
            throw new LifecycleException(e);
        }
    }

    public void store(HttpSession session) throws IOException {
        if (session == null) {
            return;
        }
        if (this.updateMode == UpdateMode.AFTER_REQUEST) {
            RedissonSession sess = (RedissonSession)this.findSession(session.getId());
            sess.save();
        }
    }

    public static enum UpdateMode {
        DEFAULT,
        AFTER_REQUEST;

    }

    public static enum ReadMode {
        REDIS,
        MEMORY;

    }
}

