/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.redisson.RedissonReference;
import org.redisson.api.RFuture;
import org.redisson.api.RObjectReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.misc.RedissonObjectFactory;
import reactor.core.publisher.Mono;

abstract class RedissonObjectReactive
implements RObjectReactive {
    final CommandReactiveExecutor commandExecutor;
    private final String name;
    final Codec codec;

    public RedissonObjectReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        this.codec = codec;
        this.name = name;
        this.commandExecutor = commandExecutor;
    }

    public <R> Publisher<R> reactive(Supplier<RFuture<R>> supplier) {
        return this.commandExecutor.reactive(supplier);
    }

    public RedissonObjectReactive(CommandReactiveExecutor commandExecutor, String name) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name);
    }

    protected <V> Mono<V> newSucceeded(V result) {
        return Mono.just(result);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Codec getCodec() {
        return this.codec;
    }

    protected void encode(Collection<Object> params, Collection<?> values) {
        for (Object object : values) {
            params.add(this.encode(object));
        }
    }

    protected ByteBuf encode(Object value) {
        RedissonReference reference;
        if (this.commandExecutor.isRedissonReferenceSupportEnabled() && (reference = RedissonObjectFactory.toReference(this.commandExecutor.getConnectionManager().getCfg(), value)) != null) {
            value = reference;
        }
        try {
            return this.codec.getValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected ByteBuf encodeMapKey(Object value) {
        RedissonReference reference;
        if (this.commandExecutor.isRedissonReferenceSupportEnabled() && (reference = RedissonObjectFactory.toReference(this.commandExecutor.getConnectionManager().getCfg(), value)) != null) {
            value = reference;
        }
        try {
            return this.codec.getMapKeyEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected ByteBuf encodeMapValue(Object value) {
        RedissonReference reference;
        if (this.commandExecutor.isRedissonReferenceSupportEnabled() && (reference = RedissonObjectFactory.toReference(this.commandExecutor.getConnectionManager().getCfg(), value)) != null) {
            value = reference;
        }
        try {
            return this.codec.getMapValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Publisher<Void> rename(String newName) {
        return this.commandExecutor.writeReactive(this.getName(), RedisCommands.RENAME, this.getName(), newName);
    }

    @Override
    public Publisher<Void> migrate(String host, int port, int database) {
        return this.commandExecutor.writeReactive(this.getName(), RedisCommands.MIGRATE, host, port, this.getName(), database);
    }

    @Override
    public Publisher<Boolean> move(int database) {
        return this.commandExecutor.writeReactive(this.getName(), RedisCommands.MOVE, this.getName(), database);
    }

    @Override
    public Publisher<Boolean> renamenx(String newName) {
        return this.commandExecutor.writeReactive(this.getName(), RedisCommands.RENAMENX, this.getName(), newName);
    }

    @Override
    public Publisher<Boolean> delete() {
        return this.commandExecutor.writeReactive(this.getName(), RedisCommands.DEL_BOOL, this.getName());
    }

    @Override
    public Publisher<Boolean> isExists() {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.EXISTS, this.getName());
    }
}

