/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class NodeAvailabilityCache<K> {
    private static final Log LOG = LogFactory.getLog(NodeAvailabilityCache.class);
    private final long _ttl;
    private final ConcurrentHashMap<K, ManagedItem<Boolean>> _map;
    private final CacheLoader<K> _cacheLoader;

    public NodeAvailabilityCache(int size, long ttlInMillis, CacheLoader<K> cacheLoader) {
        this._ttl = ttlInMillis;
        this._map = new ConcurrentHashMap(size / 2);
        this._cacheLoader = cacheLoader;
    }

    @CheckForNull
    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean setNodeAvailable(K key, boolean available) {
        ManagedItem<Boolean> item = this._map.get(key);
        Boolean availableObj = available;
        if (item == null || ((ManagedItem)item)._value != availableObj) {
            ManagedItem previous = this._map.put(key, new ManagedItem(availableObj, System.currentTimeMillis()));
            return previous != null ? (Boolean)previous._value : null;
        }
        return (Boolean)((ManagedItem)item)._value;
    }

    public boolean isNodeAvailable(@Nonnull K key) {
        ManagedItem<Boolean> item = this._map.get(key);
        if (item == null) {
            return this.updateIsNodeAvailable(key);
        }
        if (this.isExpired(item)) {
            this._map.remove(key);
            return this.updateIsNodeAvailable(key);
        }
        return (Boolean)((ManagedItem)item)._value;
    }

    private boolean isExpired(ManagedItem<Boolean> item) {
        return this._ttl > -1L && System.currentTimeMillis() - ((ManagedItem)item)._insertionTime > this._ttl;
    }

    private boolean updateIsNodeAvailable(K key) {
        Boolean result = this._cacheLoader.isNodeAvailable(key);
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheLoader returned node availability '" + result + "' for node '" + key + "'.");
        }
        this._map.put(key, new ManagedItem(result, System.currentTimeMillis()));
        return result;
    }

    public List<K> getKeys() {
        return new ArrayList(this._map.keySet());
    }

    public Set<K> getUnavailableNodes() {
        HashSet<K> result = new HashSet<K>();
        for (Map.Entry<K, ManagedItem<Boolean>> entry : this._map.entrySet()) {
            if (((Boolean)((ManagedItem)entry.getValue())._value).booleanValue() || this.isExpired(entry.getValue())) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    static interface CacheLoader<K> {
        public boolean isNodeAvailable(K var1);
    }

    private static final class ManagedItem<T> {
        private final T _value;
        private final long _insertionTime;

        private ManagedItem(T value, long accessTime) {
            this._value = value;
            this._insertionTime = accessTime;
        }
    }
}

