/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.datatype.XMLGregorianCalendar;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.DefenceModule;

public class JsonJacksonCodec
extends BaseCodec {
    public static final JsonJacksonCodec INSTANCE = new JsonJacksonCodec();
    protected final ObjectMapper mapObjectMapper;
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufOutputStream os = new ByteBufOutputStream(out);
                JsonJacksonCodec.this.mapObjectMapper.writeValue(os, in);
                return os.buffer();
            }
            catch (IOException e) {
                out.release();
                throw e;
            }
        }
    };
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            return JsonJacksonCodec.this.mapObjectMapper.readValue((InputStream)new ByteBufInputStream(buf), Object.class);
        }
    };

    public JsonJacksonCodec() {
        this(new ObjectMapper());
    }

    public JsonJacksonCodec(ClassLoader classLoader) {
        this(JsonJacksonCodec.createObjectMapper(classLoader, new ObjectMapper()));
    }

    protected static ObjectMapper createObjectMapper(ClassLoader classLoader, ObjectMapper om) {
        TypeFactory tf = TypeFactory.defaultInstance().withClassLoader(classLoader);
        om.setTypeFactory(tf);
        return om;
    }

    public JsonJacksonCodec(ObjectMapper mapObjectMapper) {
        this.mapObjectMapper = mapObjectMapper.copy();
        this.init(this.mapObjectMapper);
        this.initTypeInclusion(this.mapObjectMapper);
    }

    protected void initTypeInclusion(ObjectMapper mapObjectMapper) {
        ObjectMapper.DefaultTypeResolverBuilder mapTyper = new ObjectMapper.DefaultTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL){

            @Override
            public boolean useForType(JavaType t) {
                switch (this._appliesFor) {
                    case NON_CONCRETE_AND_ARRAYS: {
                        while (t.isArrayType()) {
                            t = t.getContentType();
                        }
                    }
                    case OBJECT_AND_NON_CONCRETE: {
                        return t.getRawClass() == Object.class || !t.isConcrete();
                    }
                    case NON_FINAL: {
                        while (t.isArrayType()) {
                            t = t.getContentType();
                        }
                        if (t.getRawClass() == Long.class) {
                            return true;
                        }
                        if (t.getRawClass() == XMLGregorianCalendar.class) {
                            return false;
                        }
                        return !t.isFinal();
                    }
                }
                return t.getRawClass() == Object.class;
            }
        };
        mapTyper.init(JsonTypeInfo.Id.CLASS, null);
        mapTyper.inclusion(JsonTypeInfo.As.PROPERTY);
        mapObjectMapper.setDefaultTyping(mapTyper);
        try {
            byte[] s = mapObjectMapper.writeValueAsBytes(1);
            mapObjectMapper.readValue(s, Object.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void init(ObjectMapper objectMapper) {
        objectMapper.registerModule(new DefenceModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setVisibility((VisibilityChecker<?>)objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.enable(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY);
        objectMapper.addMixIn(Throwable.class, ThrowableMixIn.class);
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.mapObjectMapper.getTypeFactory().getClassLoader() != null) {
            return this.mapObjectMapper.getTypeFactory().getClassLoader();
        }
        return super.getClassLoader();
    }

    public ObjectMapper getObjectMapper() {
        return this.mapObjectMapper;
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@id")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, isGetterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
    public static class ThrowableMixIn {
    }
}

