/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.CurrentRequest;
import de.javakaffee.web.msm.LRUCache;
import de.javakaffee.web.msm.LockingStrategy;
import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.RequestTrackingHostValve;
import de.javakaffee.web.msm.Statistics;
import de.javakaffee.web.msm.storage.StorageClient;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.catalina.connector.Request;

public class LockingStrategyUriPattern
extends LockingStrategy {
    private final Pattern _uriPattern;

    public LockingStrategyUriPattern(@Nonnull MemcachedSessionService manager, @Nonnull MemcachedNodesManager memcachedNodesManager, @Nonnull Pattern uriPattern, @Nonnull StorageClient storage, @Nonnull LRUCache<String, Boolean> missingSessionsCache, boolean storeSecondaryBackup, @Nonnull Statistics stats, @Nonnull CurrentRequest currentRequest) {
        super(manager, memcachedNodesManager, storage, missingSessionsCache, storeSecondaryBackup, stats, currentRequest);
        if (uriPattern == null) {
            throw new IllegalArgumentException("The uriPattern is null");
        }
        this._uriPattern = uriPattern;
    }

    @Override
    protected MemcachedSessionService.LockStatus onBeforeLoadFromMemcached(String sessionId) throws InterruptedException, ExecutionException {
        Request request = this._currentRequest.get();
        if (request == null) {
            throw new RuntimeException("There's no request set, this indicates that this findSessionwas triggered by the container which should already be handled in findSession.");
        }
        if (this._uriPattern.matcher(RequestTrackingHostValve.getURIWithQueryString(request)).matches()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Lock request for request " + RequestTrackingHostValve.getURIWithQueryString(request));
            }
            return this.lock(sessionId);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Not lock request for request " + RequestTrackingHostValve.getURIWithQueryString(request));
        }
        this._stats.nonStickySessionsReadOnlyRequest();
        return MemcachedSessionService.LockStatus.LOCK_NOT_REQUIRED;
    }
}

