/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.dns;

import io.netty.resolver.AddressResolver;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

class GroupAddressResolver
implements AddressResolver<InetSocketAddress> {
    private final List<AddressResolver<InetSocketAddress>> resolvers;

    public GroupAddressResolver(List<AddressResolver<InetSocketAddress>> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public boolean isSupported(SocketAddress address) {
        for (AddressResolver<InetSocketAddress> addressResolver : this.resolvers) {
            if (!addressResolver.isSupported(address)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isResolved(SocketAddress address) {
        for (AddressResolver<InetSocketAddress> addressResolver : this.resolvers) {
            if (!addressResolver.isResolved(address)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Future<InetSocketAddress> resolve(SocketAddress address) {
        final Promise<InetSocketAddress> promise = ImmediateEventExecutor.INSTANCE.newPromise();
        final AtomicInteger counter = new AtomicInteger(this.resolvers.size());
        for (AddressResolver<InetSocketAddress> addressResolver : this.resolvers) {
            addressResolver.resolve(address).addListener((GenericFutureListener<Future<InetSocketAddress>>)new FutureListener<InetSocketAddress>(){

                @Override
                public void operationComplete(Future<InetSocketAddress> future) throws Exception {
                    if (future.isSuccess()) {
                        promise.trySuccess(future.getNow());
                    }
                    if (counter.decrementAndGet() == 0 && !future.isSuccess()) {
                        promise.tryFailure(future.cause());
                    }
                }
            });
        }
        return promise;
    }

    @Override
    public Future<InetSocketAddress> resolve(SocketAddress address, Promise<InetSocketAddress> promise) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<List<InetSocketAddress>> resolveAll(SocketAddress address) {
        final Promise<List<InetSocketAddress>> promise = ImmediateEventExecutor.INSTANCE.newPromise();
        final AtomicInteger counter = new AtomicInteger(this.resolvers.size());
        for (AddressResolver<InetSocketAddress> addressResolver : this.resolvers) {
            addressResolver.resolveAll(address).addListener((GenericFutureListener<Future<List<InetSocketAddress>>>)new FutureListener<List<InetSocketAddress>>(){

                @Override
                public void operationComplete(Future<List<InetSocketAddress>> future) throws Exception {
                    if (future.isSuccess()) {
                        promise.trySuccess(future.getNow());
                    }
                    if (counter.decrementAndGet() == 0 && !future.isSuccess()) {
                        promise.tryFailure(future.cause());
                    }
                }
            });
        }
        return promise;
    }

    @Override
    public Future<List<InetSocketAddress>> resolveAll(SocketAddress address, Promise<List<InetSocketAddress>> promise) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }
}

