/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.reactivex.Flowable;
import io.reactivex.functions.Action;
import io.reactivex.functions.LongConsumer;
import io.reactivex.processors.ReplayProcessor;
import java.util.concurrent.Callable;
import org.redisson.api.RFuture;
import org.redisson.command.CommandAsyncService;
import org.redisson.connection.ConnectionManager;
import org.redisson.rx.CommandRxExecutor;

public class CommandRxService
extends CommandAsyncService
implements CommandRxExecutor {
    public CommandRxService(ConnectionManager connectionManager) {
        super(connectionManager);
    }

    @Override
    public <R> Flowable<R> flowable(final Callable<RFuture<R>> supplier) {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){

            @Override
            public void accept(long t) throws Exception {
                RFuture future = (RFuture)supplier.call();
                future.addListener(new FutureListener<R>(){

                    @Override
                    public void operationComplete(final Future<R> future) throws Exception {
                        if (!future.isSuccess()) {
                            p.onError(future.cause());
                            return;
                        }
                        p.doOnCancel(new Action(){

                            @Override
                            public void run() throws Exception {
                                future.cancel(true);
                            }
                        });
                        if (future.getNow() != null) {
                            p.onNext(future.getNow());
                        }
                        p.onComplete();
                    }
                });
            }
        });
    }
}

