/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.session.ManagerBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.redisson.Redisson;
import org.redisson.api.RMap;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.codec.Codec;
import org.redisson.config.Config;
import org.redisson.tomcat.AttributeMessage;
import org.redisson.tomcat.AttributeRemoveMessage;
import org.redisson.tomcat.AttributeUpdateMessage;
import org.redisson.tomcat.AttributesClearMessage;
import org.redisson.tomcat.AttributesPutAllMessage;
import org.redisson.tomcat.RedissonSession;
import org.redisson.tomcat.UpdateValve;

public class RedissonSessionManager
extends ManagerBase {
    private final Log log = LogFactory.getLog(RedissonSessionManager.class);
    private RedissonClient redisson;
    private String configPath;
    private ReadMode readMode = ReadMode.REDIS;
    private UpdateMode updateMode = UpdateMode.DEFAULT;
    private String keyPrefix = "";
    private final String nodeId = UUID.randomUUID().toString();

    public String getNodeId() {
        return this.nodeId;
    }

    public String getUpdateMode() {
        return this.updateMode.toString();
    }

    public void setUpdateMode(String updateMode) {
        this.updateMode = UpdateMode.valueOf(updateMode);
    }

    public String getReadMode() {
        return this.readMode.toString();
    }

    public void setReadMode(String readMode) {
        this.readMode = ReadMode.valueOf(readMode);
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    @Override
    public String getName() {
        return RedissonSessionManager.class.getSimpleName();
    }

    @Override
    public void load() throws ClassNotFoundException, IOException {
    }

    @Override
    public void unload() throws IOException {
    }

    @Override
    public Session createSession(String sessionId) {
        RedissonSession session = (RedissonSession)this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.getContext().getSessionTimeout() * 60);
        if (sessionId == null) {
            sessionId = this.generateSessionId();
        }
        session.setManager(this);
        session.setId(sessionId);
        session.save();
        return session;
    }

    public RMap<String, Object> getMap(String sessionId) {
        String separator = this.keyPrefix == null || this.keyPrefix.isEmpty() ? "" : ":";
        String name = this.keyPrefix + separator + "redisson:tomcat_session:" + sessionId;
        return this.redisson.getMap(name);
    }

    public RTopic getTopic() {
        String separator = this.keyPrefix == null || this.keyPrefix.isEmpty() ? "" : ":";
        String name = this.keyPrefix + separator + "redisson:tomcat_session_updates:" + this.getContext().getName();
        return this.redisson.getTopic(name);
    }

    @Override
    public Session findSession(String id) throws IOException {
        Session result = super.findSession(id);
        if (result == null) {
            if (id != null) {
                Map<Object, Object> attrs = new HashMap();
                attrs = this.readMode == ReadMode.MEMORY ? this.getMap(id).readAllMap() : this.getMap(id).getAll(RedissonSession.ATTRS);
                if (attrs.isEmpty() || !Boolean.valueOf(String.valueOf(attrs.get("session:isValid"))).booleanValue()) {
                    this.log.info("Session " + id + " can't be found");
                    return null;
                }
                RedissonSession session = (RedissonSession)this.createEmptySession();
                session.setId(id);
                session.setManager(this);
                session.load(attrs);
                session.access();
                session.endAccess();
                return session;
            }
            return null;
        }
        result.access();
        result.endAccess();
        return result;
    }

    @Override
    public Session createEmptySession() {
        return new RedissonSession(this, this.readMode, this.updateMode);
    }

    @Override
    public void remove(Session session, boolean update) {
        super.remove(session, update);
        if (session.getIdInternal() != null) {
            ((RedissonSession)session).delete();
        }
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        super.startInternal();
        this.redisson = this.buildClient();
        if (this.updateMode == UpdateMode.AFTER_REQUEST) {
            this.getEngine().getPipeline().addValve(new UpdateValve(this));
        }
        if (this.readMode == ReadMode.MEMORY) {
            RTopic updatesTopic = this.getTopic();
            updatesTopic.addListener(AttributeMessage.class, new MessageListener<AttributeMessage>(){

                @Override
                public void onMessage(CharSequence channel, AttributeMessage msg) {
                    try {
                        RedissonSession session = (RedissonSession)RedissonSessionManager.super.findSession(msg.getSessionId());
                        if (session != null && !msg.getNodeId().equals(RedissonSessionManager.this.nodeId)) {
                            AttributeMessage m;
                            if (msg instanceof AttributeRemoveMessage) {
                                session.superRemoveAttributeInternal(((AttributeRemoveMessage)msg).getName(), true);
                            }
                            if (msg instanceof AttributesClearMessage) {
                                RedissonSessionManager.super.remove(session, false);
                            }
                            if (msg instanceof AttributesPutAllMessage) {
                                m = (AttributesPutAllMessage)msg;
                                for (Map.Entry<String, Object> entry : ((AttributesPutAllMessage)m).getAttrs().entrySet()) {
                                    session.superSetAttribute(entry.getKey(), entry.getValue(), true);
                                }
                            }
                            if (msg instanceof AttributeUpdateMessage) {
                                m = (AttributeUpdateMessage)msg;
                                session.superSetAttribute(((AttributeUpdateMessage)m).getName(), ((AttributeUpdateMessage)m).getValue(), true);
                            }
                        }
                    }
                    catch (IOException e) {
                        RedissonSessionManager.this.log.error("Can't handle topic message", e);
                    }
                }
            });
        }
        this.setState(LifecycleState.STARTING);
    }

    protected RedissonClient buildClient() throws LifecycleException {
        Config config = null;
        try {
            config = Config.fromJSON(new File(this.configPath), this.getClass().getClassLoader());
        }
        catch (IOException e) {
            try {
                config = Config.fromYAML(new File(this.configPath), this.getClass().getClassLoader());
            }
            catch (IOException e1) {
                this.log.error("Can't parse json config " + this.configPath, e);
                throw new LifecycleException("Can't parse yaml config " + this.configPath, e1);
            }
        }
        try {
            try {
                Config c = new Config(config);
                Codec codec = (Codec)c.getCodec().getClass().getConstructor(ClassLoader.class).newInstance(Thread.currentThread().getContextClassLoader());
                config.setCodec(codec);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to initialize codec with ClassLoader parameter", e);
            }
            return Redisson.create(config);
        }
        catch (Exception e) {
            throw new LifecycleException(e);
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.setState(LifecycleState.STOPPING);
        try {
            if (this.redisson != null) {
                this.redisson.shutdown();
            }
        }
        catch (Exception e) {
            throw new LifecycleException(e);
        }
    }

    public void store(HttpSession session) throws IOException {
        RedissonSession sess;
        if (session == null) {
            return;
        }
        if (this.updateMode == UpdateMode.AFTER_REQUEST && (sess = (RedissonSession)super.findSession(session.getId())) != null) {
            sess.save();
        }
    }

    public static enum UpdateMode {
        DEFAULT,
        AFTER_REQUEST;

    }

    public static enum ReadMode {
        REDIS,
        MEMORY;

    }
}

