/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.bucket;

import java.util.concurrent.TimeUnit;
import org.redisson.RedissonBucket;
import org.redisson.RedissonLock;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.operation.TransactionalOperation;

public class BucketSetOperation<V>
extends TransactionalOperation {
    private Object value;
    private String lockName;
    private long timeToLive;
    private TimeUnit timeUnit;

    public BucketSetOperation(String name, String lockName, Codec codec, Object value, long timeToLive, TimeUnit timeUnit) {
        this(name, lockName, codec, value);
        this.timeToLive = timeToLive;
        this.timeUnit = timeUnit;
    }

    public BucketSetOperation(String name, String lockName, Codec codec, Object value) {
        super(name, codec);
        this.value = value;
        this.lockName = lockName;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonBucket<Object> bucket = new RedissonBucket<Object>(this.codec, commandExecutor, this.name);
        if (this.timeToLive != 0L) {
            bucket.setAsync(this.value, this.timeToLive, this.timeUnit);
        } else {
            bucket.setAsync(this.value);
        }
        RedissonLock lock = new RedissonLock(commandExecutor, this.lockName);
        lock.unlockAsync();
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonLock lock = new RedissonLock(commandExecutor, this.lockName);
        lock.unlockAsync();
    }

    public Object getValue() {
        return this.value;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

