/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.redisson.client.handler.StateLevel;
import org.redisson.client.protocol.decoder.DecoderState;

public class State {
    private int batchIndex;
    private DecoderState decoderState;
    private int level = -1;
    private List<StateLevel> levels;
    private final boolean makeCheckpoint;

    public State(boolean makeCheckpoint) {
        this.makeCheckpoint = makeCheckpoint;
    }

    public boolean isMakeCheckpoint() {
        return this.makeCheckpoint;
    }

    public int getLevel() {
        return this.level;
    }

    public StateLevel getLastLevel() {
        if (this.levels == null || this.levels.isEmpty()) {
            return null;
        }
        return this.levels.get(this.level);
    }

    public void addLevel(StateLevel stateLevel) {
        if (this.levels == null) {
            this.levels = new ArrayList<StateLevel>(2);
        }
        this.levels.add(stateLevel);
        ++this.level;
    }

    public void removeLastLevel() {
        this.levels.remove(this.level);
        --this.level;
    }

    public List<StateLevel> getLevels() {
        if (this.levels == null) {
            return Collections.emptyList();
        }
        return this.levels;
    }

    public void setBatchIndex(int index) {
        this.batchIndex = index;
    }

    public int getBatchIndex() {
        return this.batchIndex;
    }

    public <T extends DecoderState> T getDecoderState() {
        return (T)this.decoderState;
    }

    public void setDecoderState(DecoderState decoderState) {
        this.decoderState = decoderState;
    }

    public String toString() {
        return "State [batchIndex=" + this.batchIndex + ", decoderState=" + this.decoderState + ", level=" + this.level + ", levels=" + this.levels + "]";
    }
}

