/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.CurrentRequest;
import de.javakaffee.web.msm.LockingStrategy;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.RequestTrackingContextValve;
import de.javakaffee.web.msm.RequestTrackingHostValve;
import de.javakaffee.web.msm.Statistics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Response;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.SessionConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;

public class MemcachedBackupSessionManager
extends ManagerBase
implements Lifecycle,
MemcachedSessionService.SessionManager {
    protected static final String NAME = MemcachedBackupSessionManager.class.getSimpleName();
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected MemcachedSessionService _msm = new MemcachedSessionService(this){

        @Override
        protected RequestTrackingContextValve createRequestTrackingContextValve(String sessionCookieName) {
            RequestTrackingContextValve result = super.createRequestTrackingContextValve(sessionCookieName);
            result.setAsyncSupported(true);
            return result;
        }

        @Override
        protected RequestTrackingHostValve createRequestTrackingHostValve(String sessionCookieName, CurrentRequest currentRequest) {
            RequestTrackingHostValve result = super.createRequestTrackingHostValve(sessionCookieName, currentRequest);
            result.setAsyncSupported(true);
            return result;
        }
    };
    private Integer _maxInactiveInterval;
    private Boolean _contextHasFormBasedSecurityConstraint;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void load() throws ClassNotFoundException, IOException {
    }

    @Override
    public void unload() throws IOException {
    }

    @Override
    public MemcachedBackupSession createSession(String sessionId) {
        return this._msm.createSession(sessionId);
    }

    @Override
    public MemcachedBackupSession createEmptySession() {
        return this._msm.createEmptySession();
    }

    @Override
    public MemcachedBackupSession newMemcachedBackupSession() {
        return new MemcachedBackupSession(this);
    }

    @Override
    public String generateSessionId() {
        return this._msm.newSessionId(super.generateSessionId());
    }

    @Override
    public void expireSession(String sessionId) {
        if (this._log.isDebugEnabled()) {
            this._log.debug("expireSession invoked: " + sessionId);
        }
        super.expireSession(sessionId);
        this._msm.deleteFromMemcached(sessionId);
    }

    @Override
    public void remove(Session session, boolean update) {
        this.removeInternal(session, update, session.getNote("node.failure") != Boolean.TRUE);
    }

    @Override
    public void removeInternal(Session session, boolean update) {
        super.remove(session, update);
    }

    private void removeInternal(Session session, boolean update, boolean removeFromMemcached) {
        if (this._log.isDebugEnabled()) {
            this._log.debug("remove invoked, removeFromMemcached: " + removeFromMemcached + ", id: " + session.getId());
        }
        if (removeFromMemcached) {
            this._msm.deleteFromMemcached(session.getId());
        }
        super.remove(session, update);
        this._msm.sessionRemoved((MemcachedBackupSession)session);
    }

    @Override
    public Session findSession(String id) throws IOException {
        return this._msm.findSession(id);
    }

    @Override
    public void changeSessionId(Session session) {
        super.changeSessionId(session);
        ((MemcachedBackupSession)session).setSessionIdChanged(true);
    }

    @Override
    public boolean isMaxInactiveIntervalSet() {
        return this._maxInactiveInterval != null;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this._maxInactiveInterval;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        Integer oldMaxInactiveInterval = this._maxInactiveInterval;
        this._maxInactiveInterval = interval;
        this.support.firePropertyChange("maxInactiveInterval", oldMaxInactiveInterval, this._maxInactiveInterval);
    }

    @Override
    public void setMemcachedNodes(String memcachedNodes) {
        this._msm.setMemcachedNodes(memcachedNodes);
    }

    public String getMemcachedNodes() {
        return this._msm.getMemcachedNodes();
    }

    @Override
    public void setFailoverNodes(String failoverNodes) {
        this._msm.setFailoverNodes(failoverNodes);
    }

    public String getFailoverNodes() {
        return this._msm.getFailoverNodes();
    }

    public void setRequestUriIgnorePattern(String requestUriIgnorePattern) {
        this._msm.setRequestUriIgnorePattern(requestUriIgnorePattern);
    }

    @CheckForNull
    Pattern getSessionAttributePattern() {
        return this._msm.getSessionAttributePattern();
    }

    @CheckForNull
    public String getSessionAttributeFilter() {
        return this._msm.getSessionAttributeFilter();
    }

    public void setSessionAttributeFilter(@Nullable String sessionAttributeFilter) {
        this._msm.setSessionAttributeFilter(sessionAttributeFilter);
    }

    public void setTranscoderFactoryClass(String transcoderFactoryClassName) {
        this._msm.setTranscoderFactoryClass(transcoderFactoryClassName);
    }

    public void setCopyCollectionsForSerialization(boolean copyCollectionsForSerialization) {
        this._msm.setCopyCollectionsForSerialization(copyCollectionsForSerialization);
    }

    public void setCustomConverter(String customConverterClassNames) {
        this._msm.setCustomConverter(customConverterClassNames);
    }

    public void setEnableStatistics(boolean enableStatistics) {
        this._msm.setEnableStatistics(enableStatistics);
    }

    public void setBackupThreadCount(int backupThreadCount) {
        this._msm.setBackupThreadCount(backupThreadCount);
    }

    public int getBackupThreadCount() {
        return this._msm.getBackupThreadCount();
    }

    public void setMemcachedProtocol(String memcachedProtocol) {
        this._msm.setMemcachedProtocol(memcachedProtocol);
    }

    @Override
    public void setEnabled(boolean enabled) throws IllegalStateException {
        this._msm.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this._msm.isEnabled();
    }

    @Override
    public void setSticky(boolean sticky) {
        this._msm.setSticky(sticky);
    }

    public boolean isSticky() {
        return this._msm.isSticky();
    }

    @Override
    public void setOperationTimeout(long operationTimeout) {
        this._msm.setOperationTimeout(operationTimeout);
    }

    public long getOperationTimeout() {
        return this._msm.getOperationTimeout();
    }

    @Override
    public void setLockExpiration(int lockExpiration) {
        this._msm.setLockExpiration(lockExpiration);
    }

    @Override
    public void setLockingMode(@Nullable String lockingMode) {
        this._msm.setLockingMode(lockingMode);
    }

    @Override
    public void setLockingMode(@Nullable LockingStrategy.LockingMode lockingMode, @Nullable Pattern uriPattern, boolean storeSecondaryBackup) {
        this._msm.setLockingMode(lockingMode, uriPattern, storeSecondaryBackup);
    }

    @Override
    public void setUsername(String username) {
        this._msm.setUsername(username);
    }

    @Override
    public void setPassword(String password) {
        this._msm.setPassword(password);
    }

    public void setStorageKeyPrefix(String storageKeyPrefix) {
        this._msm.setStorageKeyPrefix(storageKeyPrefix);
    }

    @Override
    public void startInternal() throws LifecycleException {
        super.startInternal();
        this._msm.startInternal();
        this.setState(LifecycleState.STARTING);
    }

    @Override
    public void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        if (this._msm.isSticky()) {
            this._log.info("Removing sessions from local session map.");
            for (Session session : this.sessions.values()) {
                this.swapOut((StandardSession)session);
            }
        }
        this._msm.shutdown();
        super.stopInternal();
    }

    private void swapOut(@Nonnull StandardSession session) {
        if (!session.isValid()) {
            return;
        }
        session.passivate();
        this.removeInternal(session, true);
        session.recycle();
    }

    @Override
    public void backgroundProcess() {
        this._msm.updateExpirationInMemcached();
        super.backgroundProcess();
    }

    public void setSessionBackupAsync(boolean sessionBackupAsync) {
        this._msm.setSessionBackupAsync(sessionBackupAsync);
    }

    public boolean isSessionBackupAsync() {
        return this._msm.isSessionBackupAsync();
    }

    public void setSessionBackupTimeout(int sessionBackupTimeout) {
        this._msm.setSessionBackupTimeout(sessionBackupTimeout);
    }

    public long getSessionBackupTimeout() {
        return this._msm.getSessionBackupTimeout();
    }

    public long getMsmStatNumBackupFailures() {
        return this._msm.getStatistics().getRequestsWithBackupFailure();
    }

    public long getMsmStatNumTomcatFailover() {
        return this._msm.getStatistics().getRequestsWithTomcatFailover();
    }

    public long getMsmStatNumMemcachedFailover() {
        return this._msm.getStatistics().getRequestsWithMemcachedFailover();
    }

    public long getMsmStatNumRequestsWithoutSession() {
        return this._msm.getStatistics().getRequestsWithoutSession();
    }

    public long getMsmStatNumNoSessionAccess() {
        return this._msm.getStatistics().getRequestsWithoutSessionAccess();
    }

    public long getMsmStatNumNoAttributesAccess() {
        return this._msm.getStatistics().getRequestsWithoutAttributesAccess();
    }

    public long getMsmStatNumNoSessionModification() {
        return this._msm.getStatistics().getRequestsWithoutSessionModification();
    }

    public long getMsmStatNumRequestsWithSession() {
        return this._msm.getStatistics().getRequestsWithSession();
    }

    public long getMsmStatNumNonStickySessionsPingFailed() {
        return this._msm.getStatistics().getNonStickySessionsPingFailed();
    }

    public long getMsmStatNumNonStickySessionsReadOnlyRequest() {
        return this._msm.getStatistics().getNonStickySessionsReadOnlyRequest();
    }

    public String[] getMsmStatAttributesSerializationInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.ATTRIBUTES_SERIALIZATION).getInfo();
    }

    public String[] getMsmStatEffectiveBackupInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.EFFECTIVE_BACKUP).getInfo();
    }

    public String[] getMsmStatBackupInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.BACKUP).getInfo();
    }

    public String[] getMsmStatSessionsLoadedFromMemcachedInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.LOAD_FROM_MEMCACHED).getInfo();
    }

    public String[] getMsmStatSessionsDeletedFromMemcachedInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.DELETE_FROM_MEMCACHED).getInfo();
    }

    public String[] getMsmStatSessionDeserializationInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.SESSION_DESERIALIZATION).getInfo();
    }

    public String[] getMsmStatCachedDataSizeInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.CACHED_DATA_SIZE).getInfo();
    }

    public String[] getMsmStatMemcachedUpdateInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.MEMCACHED_UPDATE).getInfo();
    }

    public String[] getMsmStatNonStickyAcquireLockInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.ACQUIRE_LOCK).getInfo();
    }

    public String[] getMsmStatNonStickyAcquireLockFailureInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.ACQUIRE_LOCK_FAILURE).getInfo();
    }

    public String[] getMsmStatNonStickyReleaseLockInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.RELEASE_LOCK).getInfo();
    }

    public String[] getMsmStatNonStickyOnBackupWithoutLoadedSessionInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.NON_STICKY_ON_BACKUP_WITHOUT_LOADED_SESSION).getInfo();
    }

    public String[] getMsmStatNonStickyAfterBackupInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.NON_STICKY_AFTER_BACKUP).getInfo();
    }

    public String[] getMsmStatNonStickyAfterLoadFromMemcachedInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.NON_STICKY_AFTER_LOAD_FROM_MEMCACHED).getInfo();
    }

    public String[] getMsmStatNonStickyAfterDeleteFromMemcachedInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.NON_STICKY_AFTER_DELETE_FROM_MEMCACHED).getInfo();
    }

    @Override
    public String getSessionCookieName() {
        return SessionConfig.getSessionCookieName(this.getContext());
    }

    @Override
    public MemcachedBackupSession getSessionInternal(String sessionId) {
        return (MemcachedBackupSession)this.sessions.get(sessionId);
    }

    @Override
    public Map<String, Session> getSessionsInternal() {
        return this.sessions;
    }

    @Override
    public String getString(String key) {
        return sm.getString(key);
    }

    @Override
    public void incrementSessionCounter() {
        ++this.sessionCounter;
    }

    @Override
    public void incrementRejectedSessions() {
        ++this.rejectedSessions;
    }

    @Override
    public boolean isInitialized() {
        return this.getState() == LifecycleState.INITIALIZED || this.getState() == LifecycleState.STARTED;
    }

    @Override
    public String getString(String key, Object ... args) {
        return sm.getString(key, args);
    }

    @Override
    public ClassLoader getContainerClassLoader() {
        return this.getContext().getLoader().getClassLoader();
    }

    @Override
    public void writePrincipal(@Nonnull Principal principal, @Nonnull ObjectOutputStream oos) throws IOException {
        oos.writeObject(principal);
    }

    @Override
    public Principal readPrincipal(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        return (Principal)ois.readObject();
    }

    @Override
    public boolean contextHasFormBasedSecurityConstraint() {
        if (this._contextHasFormBasedSecurityConstraint != null) {
            return this._contextHasFormBasedSecurityConstraint;
        }
        SecurityConstraint[] constraints = this.getContext().findConstraints();
        LoginConfig loginConfig = this.getContext().getLoginConfig();
        this._contextHasFormBasedSecurityConstraint = constraints != null && constraints.length > 0 && loginConfig != null && "FORM".equals(loginConfig.getAuthMethod());
        return this._contextHasFormBasedSecurityConstraint;
    }

    @Override
    public MemcachedSessionService getMemcachedSessionService() {
        return this._msm;
    }

    @Override
    public String[] getSetCookieHeaders(Response response) {
        Collection<String> result = response.getHeaders("Set-Cookie");
        return result.toArray(new String[result.size()]);
    }
}

