/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.reactivex.functions.LongConsumer;
import io.reactivex.processors.ReplayProcessor;
import org.reactivestreams.Publisher;
import org.redisson.api.RFuture;
import org.redisson.api.RListAsync;
import org.redisson.rx.PublisherAdder;

public class RedissonListRx<V> {
    private final RListAsync<V> instance;

    public RedissonListRx(RListAsync<V> instance) {
        this.instance = instance;
    }

    public Publisher<V> descendingIterator() {
        return this.iterator(-1, false);
    }

    public Publisher<V> iterator() {
        return this.iterator(0, true);
    }

    public Publisher<V> descendingIterator(int startIndex) {
        return this.iterator(startIndex, false);
    }

    public Publisher<V> iterator(int startIndex) {
        return this.iterator(startIndex, true);
    }

    private Publisher<V> iterator(final int startIndex, final boolean forward) {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){
            private int currentIndex;
            {
                this.currentIndex = startIndex;
            }

            @Override
            public void accept(final long n) throws Exception {
                RedissonListRx.this.instance.getAsync(this.currentIndex).addListener(new FutureListener<V>(){

                    @Override
                    public void operationComplete(Future<V> future) throws Exception {
                        if (!future.isSuccess()) {
                            p.onError(future.cause());
                            return;
                        }
                        Object value = future.getNow();
                        if (value != null) {
                            p.onNext(value);
                            if (forward) {
                                currentIndex++;
                            } else {
                                currentIndex--;
                            }
                        }
                        if (value == null) {
                            p.onComplete();
                            return;
                        }
                        if (n - 1L == 0L) {
                            return;
                        }
                        this.accept(n - 1L);
                    }
                });
            }
        });
    }

    public Publisher<Boolean> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<V>(){

            @Override
            public RFuture<Boolean> add(Object o) {
                return RedissonListRx.this.instance.addAsync(o);
            }
        }.addAll(c);
    }
}

