/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.BackupResultStatus;
import de.javakaffee.web.msm.BackupSessionService;
import de.javakaffee.web.msm.BackupSessionTask;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.NamedThreadFactory;
import de.javakaffee.web.msm.Statistics;
import de.javakaffee.web.msm.storage.StorageClient;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class DummyMemcachedSessionService<T extends MemcachedSessionService.SessionManager>
extends MemcachedSessionService {
    private final Map<String, byte[]> _sessionData = new ConcurrentHashMap<String, byte[]>();
    private final ExecutorService _executorService = Executors.newSingleThreadExecutor(new NamedThreadFactory("dummy-msm"));

    public DummyMemcachedSessionService(T manager) {
        super((MemcachedSessionService.SessionManager)manager);
    }

    @Override
    protected StorageClient createStorageClient(MemcachedNodesManager memcachedNodesManager, Statistics statistics) {
        return null;
    }

    @Override
    protected MemcachedNodesManager.StorageClientCallback createStorageClientCallback() {
        return new MemcachedNodesManager.StorageClientCallback(){

            @Override
            public byte[] get(String key) {
                return null;
            }
        };
    }

    @Override
    protected void deleteFromMemcached(String sessionId) {
    }

    @Override
    public Future<BackupSessionTask.BackupResult> backupSession(String sessionId, boolean sessionIdChanged, String requestId) {
        MemcachedBackupSession session = this._manager.getSessionInternal(sessionId);
        if (session == null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("No session found in session map for " + sessionId);
            }
            return new BackupSessionService.SimpleFuture<BackupSessionTask.BackupResult>(BackupSessionTask.BackupResult.SKIPPED);
        }
        this._log.info("Serializing session data for session " + session.getIdInternal());
        long startSerialization = System.currentTimeMillis();
        byte[] data = this._transcoderService.serializeAttributes(session, session.getAttributesFiltered());
        this._log.info(String.format("Serializing %1$,.3f kb session data for session %2$s took %3$d ms.", (double)data.length / 1000.0, session.getIdInternal(), System.currentTimeMillis() - startSerialization));
        this._sessionData.put(session.getIdInternal(), data);
        this._statistics.registerSince(Statistics.StatsType.ATTRIBUTES_SERIALIZATION, startSerialization);
        this._statistics.register(Statistics.StatsType.CACHED_DATA_SIZE, data.length);
        return new BackupSessionService.SimpleFuture<BackupSessionTask.BackupResult>(new BackupSessionTask.BackupResult(BackupResultStatus.SUCCESS));
    }

    @Override
    public MemcachedBackupSession findSession(String id) throws IOException {
        byte[] data;
        MemcachedBackupSession result = super.findSession(id);
        if (result != null && (data = this._sessionData.remove(id)) != null) {
            this._executorService.submit(new SessionDeserialization(id, data));
        }
        return result;
    }

    @Override
    protected MemcachedBackupSession loadFromMemcachedWithCheck(String sessionId) {
        return null;
    }

    @Override
    protected void updateExpirationInMemcached() {
    }

    private final class SessionDeserialization
    implements Callable<Void> {
        private final String _id;
        private final byte[] _data;

        private SessionDeserialization(String id, byte[] data) {
            this._id = id;
            this._data = data;
        }

        @Override
        public Void call() throws Exception {
            DummyMemcachedSessionService.this._log.info(String.format("Deserializing %1$,.3f kb session data for session %2$s (asynchronously).", (double)this._data.length / 1000.0, this._id));
            long startDeserialization = System.currentTimeMillis();
            try {
                DummyMemcachedSessionService.this._transcoderService.deserializeAttributes(this._data);
            }
            catch (Exception e) {
                DummyMemcachedSessionService.this._log.warn("Could not deserialize session data.", e);
            }
            DummyMemcachedSessionService.this._log.info(String.format("Deserializing %1$,.3f kb session data for session %2$s took %3$d ms.", (double)this._data.length / 1000.0, this._id, System.currentTimeMillis() - startDeserialization));
            DummyMemcachedSessionService.this._statistics.registerSince(Statistics.StatsType.LOAD_FROM_MEMCACHED, startDeserialization);
            return null;
        }
    }
}

