/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.redisson.api.RObject;
import org.redisson.api.annotation.REntity;
import org.redisson.api.annotation.RObjectField;
import org.redisson.client.codec.Codec;
import org.redisson.codec.ReferenceCodecProvider;
import org.redisson.config.Config;
import org.redisson.liveobject.misc.ClassUtils;

public class DefaultReferenceCodecProvider
implements ReferenceCodecProvider {
    private final ConcurrentMap<Class<? extends Codec>, Codec> codecCache = new ConcurrentHashMap<Class<? extends Codec>, Codec>();

    @Override
    public <T extends Codec> T getCodec(Class<T> codecClass) {
        Codec codec = (Codec)this.codecCache.get(codecClass);
        if (codec == null) {
            try {
                codec = (Codec)codecClass.newInstance();
                this.codecCache.putIfAbsent(codecClass, codec);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return (T)codec;
    }

    @Override
    public <T extends Codec> T getCodec(REntity anno, Class<?> cls, Config config) {
        if (!ClassUtils.isAnnotationPresent(cls, anno.annotationType())) {
            throw new IllegalArgumentException("Annotation REntity does not present on type [" + cls.getCanonicalName() + "]");
        }
        Class<Codec> codecClass = anno.codec() == REntity.DEFAULT.class ? config.getCodec().getClass() : anno.codec();
        return (T)this.getCodec(codecClass);
    }

    @Override
    public <T extends Codec, K extends RObject> T getCodec(RObjectField anno, Class<?> cls, Class<K> rObjectClass, String fieldName, Config config) {
        try {
            if (!ClassUtils.getDeclaredField(cls, fieldName).isAnnotationPresent(anno.getClass())) {
                throw new IllegalArgumentException("Annotation RObjectField does not present on field " + fieldName + " of type [" + cls.getCanonicalName() + "]");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (rObjectClass.isInterface()) {
            throw new IllegalArgumentException("Cannot lookup an interface class of RObject [" + rObjectClass.getCanonicalName() + "]. Concrete class only.");
        }
        Class<Codec> codecClass = anno.codec() == RObjectField.DEFAULT.class ? config.getCodec().getClass() : anno.codec();
        return (T)this.getCodec(codecClass);
    }

    @Override
    public <T extends Codec> void registerCodec(Class<T> cls, T codec) {
        if (!cls.isInstance(codec)) {
            throw new IllegalArgumentException("codec is not an instance of the class [" + cls.getCanonicalName() + "]");
        }
        this.codecCache.putIfAbsent(cls, codec);
    }
}

