/*
 * Decompiled with CFR 0.152.
 */
package webapp.runner.launch;

import de.javakaffee.web.msm.MemcachedBackupSessionManager;
import org.apache.catalina.Context;
import webapp.runner.launch.CommandLineParams;
import webapp.runner.launch.SessionStore;

class MemcacheSessionStore
extends SessionStore {
    MemcacheSessionStore() {
    }

    @Override
    public void configureSessionStore(CommandLineParams commandLineParams, Context ctx) {
        MemcachedBackupSessionManager manager = new MemcachedBackupSessionManager();
        if (System.getenv("MEMCACHE_SERVERS") != null) {
            if (System.getenv("MEMCACHE_USERNAME") == null || System.getenv("MEMCACHE_PASSWORD") == null) {
                this.printNoConfigError();
                return;
            }
            manager.setMemcachedNodes(System.getenv("MEMCACHE_SERVERS") + ":11211");
            manager.setUsername(System.getenv("MEMCACHE_USERNAME"));
            manager.setPassword(System.getenv("MEMCACHE_PASSWORD"));
        } else if (System.getenv("MEMCACHIER_SERVERS") != null) {
            if (System.getenv("MEMCACHIER_USERNAME") == null || System.getenv("MEMCACHIER_PASSWORD") == null) {
                this.printNoConfigError();
                return;
            }
            String[] servers = System.getenv("MEMCACHIER_SERVERS").split(",");
            if (servers.length > 1) {
                for (int i = 0; i < servers.length; ++i) {
                    servers[i] = "mc" + i + ":" + servers[i];
                }
            }
            String serversStr = servers[0];
            for (int i = 1; i < servers.length; ++i) {
                serversStr = serversStr + "," + servers[i];
            }
            manager.setMemcachedNodes(serversStr);
            manager.setUsername(System.getenv("MEMCACHIER_USERNAME"));
            manager.setPassword(System.getenv("MEMCACHIER_PASSWORD"));
        } else if (System.getenv("MEMCACHEDCLOUD_SERVERS") != null) {
            if (System.getenv("MEMCACHEDCLOUD_USERNAME") == null || System.getenv("MEMCACHEDCLOUD_PASSWORD") == null) {
                this.printNoConfigError();
                return;
            }
            manager.setMemcachedNodes(System.getenv("MEMCACHEDCLOUD_SERVERS"));
            manager.setUsername(System.getenv("MEMCACHEDCLOUD_USERNAME"));
            manager.setPassword(System.getenv("MEMCACHEDCLOUD_PASSWORD"));
        } else {
            this.printNoConfigError();
            return;
        }
        manager.setMemcachedProtocol("binary");
        manager.setSticky(false);
        manager.setSessionBackupAsync(false);
        manager.setEnabled(true);
        manager.setEnableStatistics(true);
        manager.setOperationTimeout(commandLineParams.sessionStoreOperationTimout.intValue());
        manager.setLockingMode(commandLineParams.sessionStoreLockingMode);
        manager.setRequestUriIgnorePattern(commandLineParams.sessionStoreIgnorePattern);
        ctx.setManager(manager);
    }

    private void printNoConfigError() {
        System.out.println("WARNING: memcache session store being used, but the required environment variables aren't set.");
        System.out.println("Memcache session store is configured with MEMCACHE_SERVERS, MEMCACHE_USERNAME, MEMCACHE_PASSWORD");
        System.out.println("or MEMCACHIER_SERVERS, MEMCACHIER_USERNAME, MEMCACHIER_PASSWORD");
    }
}

