/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonLock;
import org.redisson.RedissonMultiMapIterator;
import org.redisson.RedissonMultiMapKeysIterator;
import org.redisson.RedissonReadWriteLock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RMultimap;
import org.redisson.api.RReadWriteLock;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.MapScanCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandExecutor;
import org.redisson.misc.Hash;
import org.redisson.misc.RedissonPromise;

public abstract class RedissonMultimap<K, V>
extends RedissonExpirable
implements RMultimap<K, V> {
    private final UUID id;
    final String prefix;

    RedissonMultimap(CommandAsyncExecutor commandAsyncExecutor, String name) {
        super(commandAsyncExecutor, name);
        this.id = commandAsyncExecutor.getConnectionManager().getId();
        this.prefix = RedissonMultimap.suffixName(this.getName(), "");
    }

    RedissonMultimap(Codec codec, CommandAsyncExecutor commandAsyncExecutor, String name) {
        super(codec, commandAsyncExecutor, name);
        this.id = commandAsyncExecutor.getConnectionManager().getId();
        this.prefix = RedissonMultimap.suffixName(this.getName(), "");
    }

    @Override
    public RLock getLock(K key) {
        String lockName = this.getLockName(key);
        return new RedissonLock((CommandExecutor)this.commandExecutor, lockName);
    }

    @Override
    public RReadWriteLock getReadWriteLock(K key) {
        String lockName = this.getLockName(key);
        return new RedissonReadWriteLock((CommandExecutor)this.commandExecutor, lockName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLockName(Object key) {
        ByteBuf keyState = this.encodeMapKey(key);
        try {
            String string = RedissonMultimap.suffixName(this.getName(), Hash.hash128toBase64(keyState) + ":key");
            return string;
        }
        finally {
            keyState.release();
        }
    }

    protected String hash(ByteBuf objectState) {
        return Hash.hash128toBase64(objectState);
    }

    protected String hashAndRelease(ByteBuf objectState) {
        try {
            String string = Hash.hash128toBase64(objectState);
            return string;
        }
        finally {
            objectState.release();
        }
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public int keySize() {
        return this.get(this.keySizeAsync());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(this.containsKeyAsync(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.get(this.containsValueAsync(value));
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        return this.get(this.containsEntryAsync(key, value));
    }

    @Override
    public boolean put(K key, V value) {
        return this.get(this.putAsync(key, value));
    }

    String getValuesName(String hash) {
        return RedissonMultimap.suffixName(this.getName(), hash);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.get(this.removeAsync(key, value));
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        return this.get(this.putAllAsync(key, values));
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Collection<V> getAll(K key) {
        return this.get(this.getAllAsync(key));
    }

    @Override
    public Collection<V> removeAll(Object key) {
        return this.get(this.removeAllAsync(key));
    }

    @Override
    public Collection<V> replaceValues(K key, Iterable<? extends V> values) {
        return this.get(this.replaceValuesAsync(key, values));
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return new EntrySet();
    }

    @Override
    public Set<K> readAllKeySet() {
        return this.get(this.readAllKeySetAsync());
    }

    @Override
    public RFuture<Set<K>> readAllKeySetAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.HKEYS, this.getName());
    }

    @Override
    public long fastRemove(K ... keys) {
        return this.get(this.fastRemoveAsync(keys));
    }

    @Override
    public RFuture<Long> fastRemoveAsync(K ... keys) {
        if (keys == null || keys.length == 0) {
            return RedissonPromise.newSucceededFuture(0L);
        }
        ArrayList<Object> mapKeys = new ArrayList<Object>(keys.length);
        ArrayList<Object> listKeys = new ArrayList<Object>(keys.length + 1);
        listKeys.add(this.getName());
        for (K key : keys) {
            ByteBuf keyState = this.encodeMapKey(key);
            mapKeys.add(keyState);
            String keyHash = this.hash(keyState);
            String name = this.getValuesName(keyHash);
            listKeys.add(name);
        }
        return this.fastRemoveAsync((List<Object>)mapKeys, (List<Object>)listKeys, RedisCommands.EVAL_LONG);
    }

    protected <T> RFuture<T> fastRemoveAsync(List<Object> mapKeys, List<Object> listKeys, RedisCommand<T> evalCommandType) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, evalCommandType, "local res = redis.call('hdel', KEYS[1], unpack(ARGV)); if res > 0 then redis.call('del', unpack(KEYS, 2, #KEYS)); end; return res; ", listKeys, mapKeys.toArray());
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN_AMOUNT, "local entries = redis.call('hgetall', KEYS[1]); local keys = {KEYS[1]}; for i, v in ipairs(entries) do if i % 2 == 0 then local name = ARGV[1] .. v; table.insert(keys, name); end;end; local n = 0 for i=1, #keys,5000 do n = n + redis.call('del', unpack(keys, i, math.min(i+4999, table.getn(keys)))) end; return n;", Arrays.asList(this.getName()), this.prefix);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local entries = redis.call('hgetall', KEYS[1]); for i, v in ipairs(entries) do if i % 2 == 0 then local name = ARGV[2] .. v; redis.call('pexpire', name, ARGV[1]); end;end; return redis.call('pexpire', KEYS[1], ARGV[1]); ", Arrays.asList(this.getName()), timeUnit.toMillis(timeToLive), this.prefix);
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local entries = redis.call('hgetall', KEYS[1]); for i, v in ipairs(entries) do if i % 2 == 0 then local name = ARGV[2] .. v; redis.call('pexpireat', name, ARGV[1]); end;end; return redis.call('pexpireat', KEYS[1], ARGV[1]); ", Arrays.asList(this.getName()), timestamp, this.prefix);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local entries = redis.call('hgetall', KEYS[1]); for i, v in ipairs(entries) do if i % 2 == 0 then local name = ARGV[1] .. v; redis.call('persist', name); end;end; return redis.call('persist', KEYS[1]); ", Arrays.asList(this.getName()), this.prefix);
    }

    @Override
    public RFuture<Integer> keySizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.HLEN, this.getName());
    }

    MapScanResult<ScanObjectEntry, ScanObjectEntry> scanIterator(RedisClient client, long startPos) {
        RFuture f = this.commandExecutor.readAsync(client, this.getName(), (Codec)new MapScanCodec(this.codec, StringCodec.INSTANCE), RedisCommands.HSCAN, this.getName(), startPos);
        return (MapScanResult)this.get(f);
    }

    abstract Iterator<V> valuesIterator();

    abstract RedissonMultiMapIterator<K, V, Map.Entry<K, V>> entryIterator();

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return RedissonMultimap.this.entryIterator();
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return RedissonMultimap.this.containsEntry(e.getKey(), e.getValue());
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return RedissonMultimap.this.remove(key, value);
            }
            return false;
        }

        @Override
        public final int size() {
            return RedissonMultimap.this.size();
        }

        @Override
        public final void clear() {
            RedissonMultimap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return RedissonMultimap.this.valuesIterator();
        }

        @Override
        public boolean contains(Object o) {
            return RedissonMultimap.this.containsValue(o);
        }

        @Override
        public int size() {
            return RedissonMultimap.this.size();
        }

        @Override
        public void clear() {
            RedissonMultimap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new RedissonMultiMapKeysIterator<K, V, K>(RedissonMultimap.this){

                @Override
                protected K getValue(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
                    return entry.getKey().getObj();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return RedissonMultimap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return RedissonMultimap.this.fastRemove(o) == 1L;
        }

        @Override
        public int size() {
            return RedissonMultimap.this.keySize();
        }

        @Override
        public void clear() {
            RedissonMultimap.this.clear();
        }
    }
}

