/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.redisson.client.RedisAskException;
import org.redisson.client.RedisException;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisOutOfMemoryException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.RedisTryAgainException;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.CommandsQueue;
import org.redisson.client.handler.State;
import org.redisson.client.handler.StateLevel;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListMultiDecoder;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.SlotsDecoder;
import org.redisson.misc.LogHelper;
import org.redisson.misc.RPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandDecoder
extends ReplayingDecoder<State> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char ZERO = '0';

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        QueueCommand data = ctx.channel().attr(CommandsQueue.CURRENT_COMMAND).get();
        if (this.log.isTraceEnabled()) {
            this.log.trace("channel: {} message: {}", (Object)ctx.channel(), (Object)in.toString(0, in.writerIndex(), CharsetUtil.UTF_8));
        }
        if (this.state() == null) {
            boolean makeCheckpoint;
            boolean bl = makeCheckpoint = data != null;
            if (data != null) {
                if (data instanceof CommandsData) {
                    makeCheckpoint = false;
                } else {
                    CommandData cmd = (CommandData)data;
                    if (cmd.getCommand().getReplayMultiDecoder() != null && (SlotsDecoder.class.isAssignableFrom(cmd.getCommand().getReplayMultiDecoder().getClass()) || ListMultiDecoder.class.isAssignableFrom(cmd.getCommand().getReplayMultiDecoder().getClass()))) {
                        makeCheckpoint = false;
                    }
                }
            }
            this.state(new State(makeCheckpoint));
        }
        ((State)this.state()).setDecoderState(null);
        if (data == null) {
            try {
                while (in.writerIndex() > in.readerIndex()) {
                    this.decode(in, null, null, ctx.channel());
                }
            }
            catch (Exception e) {
                this.log.error("Unable to decode data. channel: {} message: {}", ctx.channel(), in.toString(0, in.writerIndex(), CharsetUtil.UTF_8), e);
                this.sendNext(ctx);
                throw e;
            }
        }
        if (data instanceof CommandData) {
            CommandData cmd = (CommandData)data;
            try {
                if (((State)this.state()).getLevels().size() > 0) {
                    this.decodeFromCheckpoint(ctx, in, data, cmd);
                }
                this.decode(in, cmd, null, ctx.channel());
            }
            catch (Exception e) {
                this.log.error("Unable to decode data. channel: {} message: {}", ctx.channel(), in.toString(0, in.writerIndex(), CharsetUtil.UTF_8), e);
                cmd.tryFailure(e);
                this.sendNext(ctx);
                throw e;
            }
        } else if (data instanceof CommandsData) {
            CommandsData commands = (CommandsData)data;
            try {
                this.decodeCommandBatch(ctx, in, data, commands);
            }
            catch (Exception e) {
                commands.getPromise().tryFailure(e);
                this.sendNext(ctx);
                throw e;
            }
            return;
        }
        this.sendNext(ctx);
    }

    protected void sendNext(ChannelHandlerContext ctx) {
        ctx.pipeline().get(CommandsQueue.class).sendNextCommand(ctx.channel());
        this.state(null);
    }

    private void decodeFromCheckpoint(ChannelHandlerContext ctx, ByteBuf in, QueueCommand data, CommandData<Object, Object> cmd) throws IOException {
        StateLevel firstLevel;
        StateLevel secondLevel;
        if (((State)this.state()).getLevels().size() == 2 && (secondLevel = ((State)this.state()).getLevels().get(1)).getParts().isEmpty()) {
            ((State)this.state()).getLevels().remove(1);
        }
        if (((State)this.state()).getLevels().size() == 2) {
            firstLevel = ((State)this.state()).getLevels().get(0);
            StateLevel secondLevel2 = ((State)this.state()).getLevels().get(1);
            this.decodeList(in, cmd, firstLevel.getParts(), ctx.channel(), secondLevel2.getSize(), secondLevel2.getParts());
            MultiDecoder<Object> decoder = this.messageDecoder(cmd, firstLevel.getParts());
            if (decoder != null) {
                Object result = decoder.decode(firstLevel.getParts(), (State)this.state());
                if (data != null) {
                    this.handleResult(cmd, null, result, true, ctx.channel());
                }
            }
        }
        if (((State)this.state()).getLevels().size() == 1) {
            firstLevel = ((State)this.state()).getLevels().get(0);
            if (firstLevel.getParts().isEmpty() && firstLevel.getLastList() == null) {
                ((State)this.state()).resetLevel();
                this.decode(in, cmd, null, ctx.channel());
            } else if (firstLevel.getLastList() != null) {
                if (firstLevel.getLastList().isEmpty()) {
                    this.decode(in, cmd, firstLevel.getParts(), ctx.channel());
                } else {
                    this.decodeList(in, cmd, firstLevel.getParts(), ctx.channel(), firstLevel.getLastListSize(), firstLevel.getLastList());
                }
                firstLevel.setLastList(null);
                firstLevel.setLastListSize(0L);
                while (in.isReadable() && (long)firstLevel.getParts().size() < firstLevel.getSize()) {
                    this.decode(in, cmd, firstLevel.getParts(), ctx.channel());
                }
                this.decodeList(in, cmd, null, ctx.channel(), 0L, firstLevel.getParts());
            } else {
                this.decodeList(in, cmd, null, ctx.channel(), firstLevel.getSize(), firstLevel.getParts());
            }
        }
    }

    private void decodeCommandBatch(ChannelHandlerContext ctx, ByteBuf in, QueueCommand data, CommandsData commandBatch) throws Exception {
        int i = ((State)this.state()).getBatchIndex();
        Throwable error = null;
        while (in.writerIndex() > in.readerIndex()) {
            CommandData<Object, Object> commandData;
            block15: {
                commandData = null;
                try {
                    this.checkpoint();
                    ((State)this.state()).setBatchIndex(i);
                    RedisCommand<?> cmd = commandBatch.getCommands().get(i).getCommand();
                    if (!commandBatch.isAtomic() || RedisCommands.EXEC.getName().equals(cmd.getName()) || RedisCommands.WAIT.getName().equals(cmd.getName())) {
                        commandData = commandBatch.getCommands().get(i);
                    }
                    this.decode(in, commandData, null, ctx.channel());
                    if (commandData == null || !RedisCommands.EXEC.getName().equals(commandData.getCommand().getName()) || !commandData.getPromise().isSuccess()) break block15;
                    List objects = (List)commandData.getPromise().getNow();
                    Iterator iter = objects.iterator();
                    boolean multiFound = false;
                    for (CommandData<Object, Object> commandData2 : commandBatch.getCommands()) {
                        if (multiFound) {
                            if (!iter.hasNext()) break;
                            Object res = iter.next();
                            this.handleResult(commandData2, null, res, false, ctx.channel());
                        }
                        if (!RedisCommands.MULTI.getName().equals(commandData2.getCommand().getName())) continue;
                        multiFound = true;
                    }
                }
                catch (Exception e) {
                    if (commandData != null) {
                        commandData.tryFailure(e);
                    }
                    throw e;
                }
            }
            ++i;
            if (commandData == null || commandData.isSuccess()) continue;
            error = commandData.cause();
        }
        if (commandBatch.isSkipResult() || i == commandBatch.getCommands().size()) {
            RPromise<Void> promise = commandBatch.getPromise();
            if (error != null) {
                if (!promise.tryFailure(error) && promise.cause() instanceof RedisTimeoutException) {
                    this.log.warn("response has been skipped due to timeout! channel: {}, command: {}", (Object)ctx.channel(), (Object)LogHelper.toString(data));
                }
            } else if (!promise.trySuccess(null) && promise.cause() instanceof RedisTimeoutException) {
                this.log.warn("response has been skipped due to timeout! channel: {}, command: {}", (Object)ctx.channel(), (Object)LogHelper.toString(data));
            }
            this.sendNext(ctx);
        } else {
            this.checkpoint();
            ((State)this.state()).setBatchIndex(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ByteBuf in, CommandData<Object, Object> data, List<Object> parts, Channel channel) throws IOException {
        byte code = in.readByte();
        if (code == 43) {
            ByteBuf rb = in.readBytes(in.bytesBefore((byte)13));
            try {
                String result = rb.toString(CharsetUtil.UTF_8);
                in.skipBytes(2);
                this.handleResult(data, parts, result, false, channel);
            }
            finally {
                rb.release();
            }
        } else if (code == 45) {
            ByteBuf rb = in.readBytes(in.bytesBefore((byte)13));
            try {
                String error = rb.toString(CharsetUtil.UTF_8);
                in.skipBytes(2);
                if (error.startsWith("MOVED")) {
                    String[] errorParts = error.split(" ");
                    int slot = Integer.valueOf(errorParts[1]);
                    String addr = errorParts[2];
                    data.tryFailure(new RedisMovedException(slot, addr));
                }
                if (error.startsWith("ASK")) {
                    String[] errorParts = error.split(" ");
                    int slot = Integer.valueOf(errorParts[1]);
                    String addr = errorParts[2];
                    data.tryFailure(new RedisAskException(slot, addr));
                }
                if (error.startsWith("TRYAGAIN")) {
                    data.tryFailure(new RedisTryAgainException(error + ". channel: " + channel + " data: " + data));
                }
                if (error.startsWith("LOADING")) {
                    data.tryFailure(new RedisLoadingException(error + ". channel: " + channel + " data: " + data));
                }
                if (error.startsWith("OOM")) {
                    data.tryFailure(new RedisOutOfMemoryException(error.split("OOM ")[1] + ". channel: " + channel + " data: " + data));
                }
                if (error.contains("-OOM ")) {
                    data.tryFailure(new RedisOutOfMemoryException(error.split("-OOM ")[1] + ". channel: " + channel + " data: " + data));
                }
                if (data != null) {
                    data.tryFailure(new RedisException(error + ". channel: " + channel + " command: " + LogHelper.toString(data)));
                }
                this.log.error("Error: {} channel: {} data: {}", error, channel, LogHelper.toString(data));
            }
            finally {
                rb.release();
            }
        } else if (code == 58) {
            Long result = CommandDecoder.readLong(in);
            this.handleResult(data, parts, result, false, channel);
        } else if (code == 36) {
            ByteBuf buf = this.readBytes(in);
            Object result = null;
            if (buf != null) {
                Decoder<Object> decoder = this.selectDecoder(data, parts);
                result = decoder.decode(buf, (State)this.state());
            }
            this.handleResult(data, parts, result, false, channel);
        } else if (code == 42) {
            List<Object> respParts;
            long size = CommandDecoder.readLong(in);
            StateLevel lastLevel = ((State)this.state()).getLastLevel();
            if (lastLevel != null && lastLevel.getSize() != (long)lastLevel.getParts().size()) {
                respParts = new ArrayList<Object>();
                lastLevel.setLastListSize(size);
                lastLevel.setLastList(respParts);
            } else {
                int level = ((State)this.state()).incLevel();
                if (((State)this.state()).getLevels().size() - 1 >= level) {
                    StateLevel stateLevel = ((State)this.state()).getLevels().get(level);
                    respParts = stateLevel.getParts();
                    size = stateLevel.getSize();
                } else {
                    respParts = new ArrayList();
                    if (((State)this.state()).isMakeCheckpoint()) {
                        ((State)this.state()).addLevel(new StateLevel(size, respParts));
                    }
                }
            }
            this.decodeList(in, data, parts, channel, size, respParts);
            if (lastLevel != null && lastLevel.getLastList() != null) {
                lastLevel.setLastList(null);
                lastLevel.setLastListSize(0L);
            }
        } else {
            String dataStr = in.toString(0, in.writerIndex(), CharsetUtil.UTF_8);
            throw new IllegalStateException("Can't decode replay: " + dataStr);
        }
    }

    private void decodeList(ByteBuf in, CommandData<Object, Object> data, List<Object> parts, Channel channel, long size, List<Object> respParts) throws IOException {
        int i = respParts.size();
        while ((long)i < size) {
            this.decode(in, data, respParts, channel);
            if (((State)this.state()).isMakeCheckpoint()) {
                this.checkpoint();
            }
            ++i;
        }
        MultiDecoder<Object> decoder = this.messageDecoder(data, respParts);
        if (decoder == null) {
            return;
        }
        Object result = decoder.decode(respParts, (State)this.state());
        this.decodeResult(data, parts, channel, result);
    }

    protected void decodeResult(CommandData<Object, Object> data, List<Object> parts, Channel channel, Object result) throws IOException {
        if (data != null) {
            this.handleResult(data, parts, result, true, channel);
        }
    }

    private void handleResult(CommandData<Object, Object> data, List<Object> parts, Object result, boolean multiResult, Channel channel) {
        if (data != null) {
            result = multiResult ? data.getCommand().getConvertor().convertMulti(result) : data.getCommand().getConvertor().convert(result);
        }
        if (parts != null) {
            parts.add(result);
        } else if (data != null && !data.getPromise().trySuccess(result) && data.cause() instanceof RedisTimeoutException) {
            this.log.warn("response has been skipped due to timeout! channel: {}, command: {}, result: {}", channel, LogHelper.toString(data), LogHelper.toString(result));
        }
    }

    protected MultiDecoder<Object> messageDecoder(CommandData<Object, Object> data, List<Object> parts) {
        if (data == null && parts.isEmpty()) {
            return null;
        }
        return data.getCommand().getReplayMultiDecoder();
    }

    protected Decoder<Object> selectDecoder(CommandData<Object, Object> data, List<Object> parts) {
        MultiDecoder<Object> multiDecoder;
        Decoder<Object> mDecoder;
        if (data == null) {
            return StringCodec.INSTANCE.getValueDecoder();
        }
        Decoder<Object> decoder = data.getCommand().getReplayDecoder();
        if (parts != null && (mDecoder = (multiDecoder = data.getCommand().getReplayMultiDecoder()).getDecoder(parts.size(), (State)this.state())) != null) {
            decoder = mDecoder;
        }
        if (decoder == null) {
            decoder = data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP ? (parts.size() % 2 != 0 ? data.getCodec().getMapValueDecoder() : data.getCodec().getMapKeyDecoder()) : (data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP_KEY ? data.getCodec().getMapKeyDecoder() : (data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP_VALUE ? data.getCodec().getMapValueDecoder() : data.getCodec().getValueDecoder()));
        }
        return decoder;
    }

    public ByteBuf readBytes(ByteBuf is) throws IOException {
        long l = CommandDecoder.readLong(is);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
        }
        int size = (int)l;
        if (size == -1) {
            return null;
        }
        ByteBuf buffer = is.readSlice(size);
        byte cr = is.readByte();
        byte lf = is.readByte();
        if (cr != 13 || lf != 10) {
            throw new IOException("Improper line ending: " + cr + ", " + lf);
        }
        return buffer;
    }

    public static long readLong(ByteBuf is) throws IOException {
        long size = 0L;
        int sign = 1;
        byte read = is.readByte();
        if (read == 45) {
            read = is.readByte();
            sign = -1;
        }
        while (read != 13 || is.readByte() != 10) {
            int value = read - 48;
            if (value >= 0 && value < 10) {
                size *= 10L;
                size += (long)value;
            } else {
                throw new IOException("Invalid character in integer");
            }
            read = is.readByte();
        }
        return size * (long)sign;
    }
}

