/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.SessionIdFormat;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.ops.Operation;

class SuffixBasedNodeLocator
implements NodeLocator {
    private final List<MemcachedNode> _nodes;
    private final MemcachedNodesManager _memcachedNodesManager;
    private final Map<String, MemcachedNode> _nodesMap;
    private final SessionIdFormat _sessionIdFormat;

    public SuffixBasedNodeLocator(List<MemcachedNode> nodes, MemcachedNodesManager memcachedNodesManager, SessionIdFormat sessionIdFormat) {
        this._nodes = nodes;
        this._memcachedNodesManager = memcachedNodesManager;
        HashMap<String, MemcachedNode> map = new HashMap<String, MemcachedNode>(nodes.size(), 1.0f);
        for (int i = 0; i < nodes.size(); ++i) {
            MemcachedNode memcachedNode = nodes.get(i);
            String nodeId = memcachedNodesManager.getNodeId((InetSocketAddress)memcachedNode.getSocketAddress());
            map.put(nodeId, memcachedNode);
        }
        this._nodesMap = map;
        this._sessionIdFormat = sessionIdFormat;
    }

    @Override
    public void updateLocator(List<MemcachedNode> nodes) {
        throw new UnsupportedOperationException("Not yet supported.");
    }

    @Override
    public Collection<MemcachedNode> getAll() {
        return this._nodesMap.values();
    }

    @Override
    public MemcachedNode getPrimary(String key) {
        String nodeId = this.getNodeId(key);
        MemcachedNode result = this._nodesMap.get(nodeId);
        if (result == null) {
            throw new IllegalArgumentException("No node found for key " + key + " (nodeId: " + nodeId + ", known nodeIds: " + this._nodesMap.keySet() + ")");
        }
        return result;
    }

    private String getNodeId(String key) {
        String nodeId = this._sessionIdFormat.extractMemcachedId(key);
        if (!this._sessionIdFormat.isBackupKey(key)) {
            return nodeId;
        }
        return this._memcachedNodesManager.getNextAvailableNodeId(nodeId);
    }

    @Override
    public Iterator<MemcachedNode> getSequence(String key) {
        throw new UnsupportedOperationException("This should not be called as we specified FailureMode.Cancel.");
    }

    @Override
    public NodeLocator getReadonlyCopy() {
        ArrayList<MemcachedNode> nodes = new ArrayList<MemcachedNode>();
        for (MemcachedNode node : this._nodes) {
            nodes.add(new MyMemcachedNodeROImpl(node));
        }
        return new SuffixBasedNodeLocator(nodes, this._memcachedNodesManager, this._sessionIdFormat);
    }

    static class MyMemcachedNodeROImpl
    implements MemcachedNode {
        private final MemcachedNode root;

        public MyMemcachedNodeROImpl(MemcachedNode node) {
            this.root = node;
        }

        public String toString() {
            return this.root.toString();
        }

        @Override
        public void addOp(Operation op) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertOp(Operation op) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void connected() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyInputQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void fillWriteBuffer(boolean optimizeGets) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void fixupOps() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getBytesRemainingToWrite() {
            return this.root.getBytesRemainingToWrite();
        }

        @Override
        public SocketChannel getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Operation getCurrentReadOp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Operation getCurrentWriteOp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer getRbuf() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getReconnectCount() {
            return this.root.getReconnectCount();
        }

        @Override
        public int getSelectionOps() {
            return this.root.getSelectionOps();
        }

        @Override
        public SelectionKey getSk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SocketAddress getSocketAddress() {
            return this.root.getSocketAddress();
        }

        @Override
        public ByteBuffer getWbuf() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasReadOp() {
            return this.root.hasReadOp();
        }

        @Override
        public boolean hasWriteOp() {
            return this.root.hasReadOp();
        }

        @Override
        public boolean isActive() {
            return this.root.isActive();
        }

        @Override
        public void reconnecting() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void registerChannel(SocketChannel ch, SelectionKey selectionKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Operation removeCurrentReadOp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Operation removeCurrentWriteOp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setChannel(SocketChannel to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSk(SelectionKey to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setupResend() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void transitionWriteItem() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int writeSome() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Operation> destroyInputQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void authComplete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setupForAuth() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getContinuousTimeout() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setContinuousTimeout(boolean isIncrease) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAuthenticated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long lastReadDelta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void completedRead() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MemcachedConnection getConnection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setConnection(MemcachedConnection mc) {
            throw new UnsupportedOperationException();
        }
    }
}

