/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class SplitPackageBinding
extends PackageBinding {
    Set<ModuleBinding> declaringModules = new HashSet<ModuleBinding>();
    public Set<PackageBinding> incarnations = new HashSet<PackageBinding>();

    public static PackageBinding combine(PackageBinding binding, PackageBinding previous, ModuleBinding primaryModule) {
        int curRank;
        int prevRank = SplitPackageBinding.rank(previous);
        if (prevRank < (curRank = SplitPackageBinding.rank(binding))) {
            return binding;
        }
        if (prevRank > curRank) {
            return previous;
        }
        if (previous == null) {
            return null;
        }
        if (previous.subsumes(binding)) {
            return previous;
        }
        if (binding.subsumes(previous)) {
            return binding;
        }
        SplitPackageBinding split2 = new SplitPackageBinding(previous, primaryModule);
        split2.add(binding);
        return split2;
    }

    private static int rank(PackageBinding candidate) {
        if (candidate == null) {
            return 0;
        }
        if (candidate == LookupEnvironment.TheNotFoundPackage) {
            return 1;
        }
        if (!candidate.isValidBinding()) {
            return 2;
        }
        return 3;
    }

    public SplitPackageBinding(PackageBinding initialBinding, ModuleBinding primaryModule) {
        super(initialBinding.compoundName, initialBinding.parent, primaryModule.environment, primaryModule);
        this.add(initialBinding);
    }

    public void add(PackageBinding packageBinding) {
        if (packageBinding instanceof SplitPackageBinding) {
            SplitPackageBinding split2 = (SplitPackageBinding)packageBinding;
            this.declaringModules.addAll(split2.declaringModules);
            for (PackageBinding incarnation : split2.incarnations) {
                if (!this.incarnations.add(incarnation)) continue;
                incarnation.addWrappingSplitPackageBinding(this);
            }
        } else {
            this.declaringModules.add(packageBinding.enclosingModule);
            if (this.incarnations.add(packageBinding)) {
                packageBinding.addWrappingSplitPackageBinding(this);
            }
        }
    }

    PackageBinding addPackage(PackageBinding element, ModuleBinding module) {
        return this.addPackage(element, module, true);
    }

    @Override
    PackageBinding addPackage(PackageBinding element, ModuleBinding module, boolean enrichWithSplitSiblings) {
        char[] simpleName = element.compoundName[element.compoundName.length - 1];
        if (enrichWithSplitSiblings) {
            element = this.combineWithSiblings(element, simpleName, module);
        }
        PackageBinding visible = this.knownPackages.get(simpleName);
        visible = SplitPackageBinding.combine(element, visible, this.enclosingModule);
        this.knownPackages.put(simpleName, visible);
        PackageBinding incarnation = this.getIncarnation(element.enclosingModule);
        if (incarnation != null) {
            incarnation.addPackage(element, module, enrichWithSplitSiblings);
        }
        return element;
    }

    PackageBinding combineWithSiblings(PackageBinding childPackage, char[] name, ModuleBinding module) {
        ModuleBinding primaryModule = childPackage != null ? childPackage.enclosingModule : this.enclosingModule;
        boolean activeSave = primaryModule.isPackageLookupActive;
        primaryModule.isPackageLookupActive = true;
        try {
            for (PackageBinding incarnation : this.incarnations) {
                ModuleBinding moduleBinding = incarnation.enclosingModule;
                if (moduleBinding == module) continue;
                PackageBinding next = moduleBinding.getVisiblePackage(incarnation, name);
                childPackage = SplitPackageBinding.combine(next, childPackage, primaryModule);
            }
            PackageBinding packageBinding = childPackage;
            return packageBinding;
        }
        finally {
            primaryModule.isPackageLookupActive = activeSave;
        }
    }

    @Override
    ModuleBinding[] getDeclaringModules() {
        return this.declaringModules.toArray(new ModuleBinding[this.declaringModules.size()]);
    }

    @Override
    PackageBinding getPackage0(char[] name) {
        PackageBinding knownPackage = super.getPackage0(name);
        if (knownPackage != null) {
            return knownPackage;
        }
        PackageBinding candidate = null;
        for (PackageBinding incarnation : this.incarnations) {
            PackageBinding package0 = incarnation.getPackage0(name);
            if (package0 == null) {
                return null;
            }
            candidate = SplitPackageBinding.combine(package0, candidate, this.enclosingModule);
        }
        if (candidate != null) {
            this.knownPackages.put(name, candidate);
        }
        return candidate;
    }

    @Override
    PackageBinding getPackage0Any(char[] name) {
        PackageBinding knownPackage = super.getPackage0(name);
        if (knownPackage != null) {
            return knownPackage;
        }
        PackageBinding candidate = null;
        for (PackageBinding incarnation : this.incarnations) {
            PackageBinding package0 = incarnation.getPackage0(name);
            if (package0 == null) continue;
            candidate = SplitPackageBinding.combine(package0, candidate, this.enclosingModule);
        }
        return candidate;
    }

    @Override
    protected PackageBinding findPackage(char[] name, ModuleBinding module) {
        HashSet<PackageBinding> candidates = new HashSet<PackageBinding>();
        for (ModuleBinding candidateModule : this.declaringModules) {
            PackageBinding candidate = super.findPackage(name, candidateModule);
            if (candidate == null || candidate == LookupEnvironment.TheNotFoundPackage || (candidate.tagBits & 0x80L) != 0L) continue;
            candidates.add(candidate);
        }
        int count = candidates.size();
        PackageBinding result = null;
        if (count == 1) {
            result = (PackageBinding)candidates.iterator().next();
        } else if (count > 1) {
            Iterator iterator = candidates.iterator();
            SplitPackageBinding split2 = new SplitPackageBinding((PackageBinding)iterator.next(), this.enclosingModule);
            while (iterator.hasNext()) {
                split2.add((PackageBinding)iterator.next());
            }
            result = split2;
        }
        if (result == null) {
            this.addNotFoundPackage(name);
        } else {
            this.addPackage(result, module);
        }
        return result;
    }

    public PackageBinding getIncarnation(ModuleBinding requestedModule) {
        for (PackageBinding incarnation : this.incarnations) {
            if (incarnation.enclosingModule != requestedModule) continue;
            return incarnation;
        }
        return null;
    }

    @Override
    public boolean subsumes(PackageBinding binding) {
        if (!CharOperation.equals(this.compoundName, binding.compoundName)) {
            return false;
        }
        if (binding instanceof SplitPackageBinding) {
            return this.declaringModules.containsAll(((SplitPackageBinding)binding).declaringModules);
        }
        return this.declaringModules.contains(binding.enclosingModule);
    }

    @Override
    ReferenceBinding getType0(char[] name) {
        ReferenceBinding knownType = super.getType0(name);
        if (knownType != null) {
            return knownType;
        }
        ReferenceBinding candidate = null;
        for (PackageBinding incarnation : this.incarnations) {
            ReferenceBinding next = incarnation.getType0(name);
            if (next == null || !next.isValidBinding()) continue;
            if (candidate != null) {
                return null;
            }
            candidate = next;
        }
        if (candidate != null) {
            this.addType(candidate);
        }
        return candidate;
    }

    ReferenceBinding getType0ForModule(ModuleBinding module, char[] name) {
        if (this.declaringModules.contains(module)) {
            return this.getIncarnation(module).getType0(name);
        }
        return null;
    }

    @Override
    ReferenceBinding getType(char[] name, ModuleBinding mod) {
        ReferenceBinding candidate = null;
        boolean accessible = false;
        for (PackageBinding incarnation : this.incarnations) {
            ReferenceBinding type = incarnation.getType(name, mod);
            if (type == null) continue;
            if (candidate == null || !accessible) {
                candidate = type;
                accessible = mod.canAccess(incarnation);
                continue;
            }
            if (!mod.canAccess(incarnation)) continue;
            return new ProblemReferenceBinding(type.compoundName, candidate, 3);
        }
        if (candidate != null && !accessible) {
            return new ProblemReferenceBinding(candidate.compoundName, candidate, 30);
        }
        return candidate;
    }

    @Override
    public boolean isDeclaredIn(ModuleBinding moduleBinding) {
        return this.declaringModules.contains(moduleBinding);
    }

    @Override
    public PackageBinding getVisibleFor(ModuleBinding clientModule) {
        int visibleCount = 0;
        PackageBinding unique = null;
        for (PackageBinding incarnation : this.incarnations) {
            if (!incarnation.hasCompilationUnit(false)) continue;
            if (incarnation.enclosingModule == clientModule) {
                return incarnation;
            }
            if (!clientModule.canAccess(incarnation)) continue;
            if (++visibleCount > 1) {
                return this;
            }
            unique = incarnation;
        }
        return unique;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append(" (from ");
        String sep = "";
        for (ModuleBinding mod : this.declaringModules) {
            buf.append(sep).append(mod.readableName());
            sep = ", ";
        }
        buf.append(")");
        return buf.toString();
    }
}

