/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.reactivex.Flowable;
import io.reactivex.functions.LongConsumer;
import io.reactivex.processors.ReplayProcessor;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;

public abstract class SetRxIterator<V> {
    public Flowable<V> create() {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){
            private long nextIterPos;
            private RedisClient client;
            private AtomicLong elementsRead = new AtomicLong();
            private boolean finished;
            private volatile boolean completed;
            private AtomicLong readAmount = new AtomicLong();

            @Override
            public void accept(long value) {
                this.readAmount.addAndGet(value);
                if (this.completed || this.elementsRead.get() == 0L) {
                    this.nextValues();
                    this.completed = false;
                }
            }

            protected void nextValues() {
                SetRxIterator.this.scanIterator(this.client, this.nextIterPos).addListener(new FutureListener<ListScanResult<Object>>(){

                    @Override
                    public void operationComplete(Future<ListScanResult<Object>> future) throws Exception {
                        if (!future.isSuccess()) {
                            p.onError(future.cause());
                            return;
                        }
                        if (finished) {
                            client = null;
                            nextIterPos = 0L;
                            return;
                        }
                        ListScanResult<Object> res = future.getNow();
                        client = res.getRedisClient();
                        nextIterPos = res.getPos();
                        for (Object val : res.getValues()) {
                            p.onNext(val);
                            elementsRead.incrementAndGet();
                        }
                        if (elementsRead.get() >= readAmount.get()) {
                            p.onComplete();
                            elementsRead.set(0L);
                            completed = true;
                            return;
                        }
                        if (res.getPos() == 0L && !SetRxIterator.this.tryAgain()) {
                            finished = true;
                            p.onComplete();
                        }
                        if (finished || completed) {
                            return;
                        }
                        this.nextValues();
                    }
                });
            }
        });
    }

    protected boolean tryAgain() {
        return false;
    }

    protected abstract RFuture<ListScanResult<Object>> scanIterator(RedisClient var1, long var2);
}

