/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.misc.URIBuilder;

public class ReplicatedServersConfig
extends BaseMasterSlaveServersConfig<ReplicatedServersConfig> {
    private List<URI> nodeAddresses = new ArrayList<URI>();
    private int scanInterval = 1000;
    private int database = 0;

    public ReplicatedServersConfig() {
    }

    ReplicatedServersConfig(ReplicatedServersConfig config) {
        super(config);
        this.setNodeAddresses(config.getNodeAddresses());
        this.setScanInterval(config.getScanInterval());
        this.setDatabase(config.getDatabase());
    }

    public ReplicatedServersConfig addNodeAddress(String ... addresses) {
        for (String address : addresses) {
            this.nodeAddresses.add(URIBuilder.create(address));
        }
        return this;
    }

    public List<URI> getNodeAddresses() {
        return this.nodeAddresses;
    }

    void setNodeAddresses(List<URI> nodeAddresses) {
        this.nodeAddresses = nodeAddresses;
    }

    public int getScanInterval() {
        return this.scanInterval;
    }

    public ReplicatedServersConfig setScanInterval(int scanInterval) {
        this.scanInterval = scanInterval;
        return this;
    }

    public ReplicatedServersConfig setDatabase(int database) {
        this.database = database;
        return this;
    }

    public int getDatabase() {
        return this.database;
    }
}

