/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SendfileDataBase;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.WriteBuffer;
import org.apache.tomcat.util.res.StringManager;

public abstract class SocketWrapperBase<E> {
    private static final Log log = LogFactory.getLog(SocketWrapperBase.class);
    protected static final StringManager sm = StringManager.getManager(SocketWrapperBase.class);
    private final E socket;
    private final AbstractEndpoint<E, ?> endpoint;
    private volatile long readTimeout = -1L;
    private volatile long writeTimeout = -1L;
    private volatile int keepAliveLeft = 100;
    private volatile boolean upgraded = false;
    private boolean secure = false;
    private String negotiatedProtocol = null;
    protected String localAddr = null;
    protected String localName = null;
    protected int localPort = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected int remotePort = -1;
    private volatile boolean blockingStatus = true;
    private final Lock blockingStatusReadLock;
    private final ReentrantReadWriteLock.WriteLock blockingStatusWriteLock;
    private volatile IOException error = null;
    protected volatile SocketBufferHandler socketBufferHandler = null;
    protected int bufferedWriteSize = 65536;
    protected final WriteBuffer nonBlockingWriteBuffer = new WriteBuffer(this.bufferedWriteSize);
    public static final CompletionCheck COMPLETE_WRITE = new CompletionCheck(){

        @Override
        public CompletionHandlerCall callHandler(CompletionState state, ByteBuffer[] buffers, int offset, int length) {
            for (int i = 0; i < length; ++i) {
                if (!buffers[offset + i].hasRemaining()) continue;
                return CompletionHandlerCall.CONTINUE;
            }
            return state == CompletionState.DONE ? CompletionHandlerCall.DONE : CompletionHandlerCall.NONE;
        }
    };
    public static final CompletionCheck COMPLETE_WRITE_WITH_COMPLETION = new CompletionCheck(){

        @Override
        public CompletionHandlerCall callHandler(CompletionState state, ByteBuffer[] buffers, int offset, int length) {
            for (int i = 0; i < length; ++i) {
                if (!buffers[offset + i].hasRemaining()) continue;
                return CompletionHandlerCall.CONTINUE;
            }
            return CompletionHandlerCall.DONE;
        }
    };
    public static final CompletionCheck READ_DATA = new CompletionCheck(){

        @Override
        public CompletionHandlerCall callHandler(CompletionState state, ByteBuffer[] buffers, int offset, int length) {
            return state == CompletionState.DONE ? CompletionHandlerCall.DONE : CompletionHandlerCall.NONE;
        }
    };
    public static final CompletionCheck COMPLETE_READ_WITH_COMPLETION = COMPLETE_WRITE_WITH_COMPLETION;
    public static final CompletionCheck COMPLETE_READ = COMPLETE_WRITE;

    public SocketWrapperBase(E socket, AbstractEndpoint<E, ?> endpoint) {
        this.socket = socket;
        this.endpoint = endpoint;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.blockingStatusReadLock = lock.readLock();
        this.blockingStatusWriteLock = lock.writeLock();
    }

    public E getSocket() {
        return this.socket;
    }

    protected AbstractEndpoint<E, ?> getEndpoint() {
        return this.endpoint;
    }

    public void execute(Runnable runnable) {
        Executor executor = this.endpoint.getExecutor();
        if (!this.endpoint.isRunning() || executor == null) {
            throw new RejectedExecutionException();
        }
        executor.execute(runnable);
    }

    public IOException getError() {
        return this.error;
    }

    public void setError(IOException error) {
        if (this.error != null) {
            return;
        }
        this.error = error;
    }

    public void checkError() throws IOException {
        if (this.error != null) {
            throw this.error;
        }
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public void setUpgraded(boolean upgraded) {
        this.upgraded = upgraded;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getNegotiatedProtocol() {
        return this.negotiatedProtocol;
    }

    public void setNegotiatedProtocol(String negotiatedProtocol) {
        this.negotiatedProtocol = negotiatedProtocol;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout > 0L ? readTimeout : -1L;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout > 0L ? writeTimeout : -1L;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setKeepAliveLeft(int keepAliveLeft) {
        this.keepAliveLeft = keepAliveLeft;
    }

    public int decrementKeepAlive() {
        return --this.keepAliveLeft;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.populateRemoteHost();
        }
        return this.remoteHost;
    }

    protected abstract void populateRemoteHost();

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.populateRemoteAddr();
        }
        return this.remoteAddr;
    }

    protected abstract void populateRemoteAddr();

    public int getRemotePort() {
        if (this.remotePort == -1) {
            this.populateRemotePort();
        }
        return this.remotePort;
    }

    protected abstract void populateRemotePort();

    public String getLocalName() {
        if (this.localName == null) {
            this.populateLocalName();
        }
        return this.localName;
    }

    protected abstract void populateLocalName();

    public String getLocalAddr() {
        if (this.localAddr == null) {
            this.populateLocalAddr();
        }
        return this.localAddr;
    }

    protected abstract void populateLocalAddr();

    public int getLocalPort() {
        if (this.localPort == -1) {
            this.populateLocalPort();
        }
        return this.localPort;
    }

    protected abstract void populateLocalPort();

    public boolean getBlockingStatus() {
        return this.blockingStatus;
    }

    public void setBlockingStatus(boolean blockingStatus) {
        this.blockingStatus = blockingStatus;
    }

    public Lock getBlockingStatusReadLock() {
        return this.blockingStatusReadLock;
    }

    public ReentrantReadWriteLock.WriteLock getBlockingStatusWriteLock() {
        return this.blockingStatusWriteLock;
    }

    public SocketBufferHandler getSocketBufferHandler() {
        return this.socketBufferHandler;
    }

    public boolean hasDataToRead() {
        return true;
    }

    public boolean hasDataToWrite() {
        return !this.socketBufferHandler.isWriteBufferEmpty() || !this.nonBlockingWriteBuffer.isEmpty();
    }

    public boolean isReadyForWrite() {
        boolean result = this.canWrite();
        if (!result) {
            this.registerWriteInterest();
        }
        return result;
    }

    public boolean canWrite() {
        if (this.socketBufferHandler == null) {
            throw new IllegalStateException(sm.getString("socket.closed"));
        }
        return this.socketBufferHandler.isWriteBufferWritable() && this.nonBlockingWriteBuffer.isEmpty();
    }

    public String toString() {
        return super.toString() + ":" + String.valueOf(this.socket);
    }

    public abstract int read(boolean var1, byte[] var2, int var3, int var4) throws IOException;

    public abstract int read(boolean var1, ByteBuffer var2) throws IOException;

    public abstract boolean isReadyForRead() throws IOException;

    public abstract void setAppReadBufHandler(ApplicationBufferHandler var1);

    protected int populateReadBuffer(byte[] b, int off, int len) {
        this.socketBufferHandler.configureReadBufferForRead();
        ByteBuffer readBuffer = this.socketBufferHandler.getReadBuffer();
        int remaining = readBuffer.remaining();
        if (remaining > 0) {
            remaining = Math.min(remaining, len);
            readBuffer.get(b, off, remaining);
            if (log.isDebugEnabled()) {
                log.debug("Socket: [" + this + "], Read from buffer: [" + remaining + "]");
            }
        }
        return remaining;
    }

    protected int populateReadBuffer(ByteBuffer to) {
        this.socketBufferHandler.configureReadBufferForRead();
        int nRead = SocketWrapperBase.transfer(this.socketBufferHandler.getReadBuffer(), to);
        if (log.isDebugEnabled()) {
            log.debug("Socket: [" + this + "], Read from buffer: [" + nRead + "]");
        }
        return nRead;
    }

    public void unRead(ByteBuffer returnedInput) {
        if (returnedInput != null) {
            this.socketBufferHandler.configureReadBufferForWrite();
            this.socketBufferHandler.getReadBuffer().put(returnedInput);
        }
    }

    public abstract void close() throws IOException;

    public abstract boolean isClosed();

    public final void write(boolean block, byte[] buf, int off, int len) throws IOException {
        if (len == 0 || buf == null) {
            return;
        }
        if (block) {
            this.writeBlocking(buf, off, len);
        } else {
            this.writeNonBlocking(buf, off, len);
        }
    }

    public final void write(boolean block, ByteBuffer from) throws IOException {
        if (from == null || from.remaining() == 0) {
            return;
        }
        if (block) {
            this.writeBlocking(from);
        } else {
            this.writeNonBlocking(from);
        }
    }

    protected void writeBlocking(byte[] buf, int off, int len) throws IOException {
        this.socketBufferHandler.configureWriteBufferForWrite();
        int thisTime = SocketWrapperBase.transfer(buf, off, len, this.socketBufferHandler.getWriteBuffer());
        while (this.socketBufferHandler.getWriteBuffer().remaining() == 0) {
            this.doWrite(true);
            this.socketBufferHandler.configureWriteBufferForWrite();
            thisTime = SocketWrapperBase.transfer(buf, off += thisTime, len -= thisTime, this.socketBufferHandler.getWriteBuffer());
        }
    }

    protected void writeBlocking(ByteBuffer from) throws IOException {
        if (this.socketBufferHandler.isWriteBufferEmpty()) {
            this.writeBlockingDirect(from);
        } else {
            this.socketBufferHandler.configureWriteBufferForWrite();
            SocketWrapperBase.transfer(from, this.socketBufferHandler.getWriteBuffer());
            if (!this.socketBufferHandler.isWriteBufferWritable()) {
                this.doWrite(true);
                this.writeBlockingDirect(from);
            }
        }
    }

    protected void writeBlockingDirect(ByteBuffer from) throws IOException {
        int limit = this.socketBufferHandler.getWriteBuffer().capacity();
        int fromLimit = from.limit();
        while (from.remaining() >= limit) {
            from.limit(from.position() + limit);
            this.doWrite(true, from);
            from.limit(fromLimit);
        }
        if (from.remaining() > 0) {
            this.socketBufferHandler.configureWriteBufferForWrite();
            SocketWrapperBase.transfer(from, this.socketBufferHandler.getWriteBuffer());
        }
    }

    protected void writeNonBlocking(byte[] buf, int off, int len) throws IOException {
        if (this.nonBlockingWriteBuffer.isEmpty() && this.socketBufferHandler.isWriteBufferWritable()) {
            this.socketBufferHandler.configureWriteBufferForWrite();
            int thisTime = SocketWrapperBase.transfer(buf, off, len, this.socketBufferHandler.getWriteBuffer());
            len -= thisTime;
            while (!this.socketBufferHandler.isWriteBufferWritable()) {
                off += thisTime;
                this.doWrite(false);
                if (len <= 0 || !this.socketBufferHandler.isWriteBufferWritable()) break;
                this.socketBufferHandler.configureWriteBufferForWrite();
                thisTime = SocketWrapperBase.transfer(buf, off, len, this.socketBufferHandler.getWriteBuffer());
                len -= thisTime;
            }
        }
        if (len > 0) {
            this.nonBlockingWriteBuffer.add(buf, off, len);
        }
    }

    protected void writeNonBlocking(ByteBuffer from) throws IOException {
        if (this.nonBlockingWriteBuffer.isEmpty() && this.socketBufferHandler.isWriteBufferWritable()) {
            this.writeNonBlockingInternal(from);
        }
        if (from.remaining() > 0) {
            this.nonBlockingWriteBuffer.add(from);
        }
    }

    protected void writeNonBlockingInternal(ByteBuffer from) throws IOException {
        if (this.socketBufferHandler.isWriteBufferEmpty()) {
            this.writeNonBlockingDirect(from);
        } else {
            this.socketBufferHandler.configureWriteBufferForWrite();
            SocketWrapperBase.transfer(from, this.socketBufferHandler.getWriteBuffer());
            if (!this.socketBufferHandler.isWriteBufferWritable()) {
                this.doWrite(false);
                if (this.socketBufferHandler.isWriteBufferWritable()) {
                    this.writeNonBlockingDirect(from);
                }
            }
        }
    }

    protected void writeNonBlockingDirect(ByteBuffer from) throws IOException {
        int limit = this.socketBufferHandler.getWriteBuffer().capacity();
        int fromLimit = from.limit();
        while (from.remaining() >= limit) {
            int newLimit = from.position() + limit;
            from.limit(newLimit);
            this.doWrite(false, from);
            from.limit(fromLimit);
            if (from.position() == newLimit) continue;
            return;
        }
        if (from.remaining() > 0) {
            this.socketBufferHandler.configureWriteBufferForWrite();
            SocketWrapperBase.transfer(from, this.socketBufferHandler.getWriteBuffer());
        }
    }

    public boolean flush(boolean block) throws IOException {
        boolean result = false;
        if (block) {
            this.flushBlocking();
        } else {
            result = this.flushNonBlocking();
        }
        return result;
    }

    protected void flushBlocking() throws IOException {
        this.doWrite(true);
        if (!this.nonBlockingWriteBuffer.isEmpty()) {
            this.nonBlockingWriteBuffer.write(this, true);
            if (!this.socketBufferHandler.isWriteBufferEmpty()) {
                this.doWrite(true);
            }
        }
    }

    protected boolean flushNonBlocking() throws IOException {
        boolean dataLeft;
        boolean bl = dataLeft = !this.socketBufferHandler.isWriteBufferEmpty();
        if (dataLeft) {
            this.doWrite(false);
            boolean bl2 = dataLeft = !this.socketBufferHandler.isWriteBufferEmpty();
        }
        if (!(dataLeft || this.nonBlockingWriteBuffer.isEmpty() || (dataLeft = this.nonBlockingWriteBuffer.write(this, false)) || this.socketBufferHandler.isWriteBufferEmpty())) {
            this.doWrite(false);
            dataLeft = !this.socketBufferHandler.isWriteBufferEmpty();
        }
        return dataLeft;
    }

    protected void doWrite(boolean block) throws IOException {
        this.socketBufferHandler.configureWriteBufferForRead();
        this.doWrite(block, this.socketBufferHandler.getWriteBuffer());
    }

    protected abstract void doWrite(boolean var1, ByteBuffer var2) throws IOException;

    public void processSocket(SocketEvent socketStatus, boolean dispatch) {
        this.endpoint.processSocket(this, socketStatus, dispatch);
    }

    public abstract void registerReadInterest();

    public abstract void registerWriteInterest();

    public abstract SendfileDataBase createSendfileData(String var1, long var2, long var4);

    public abstract SendfileState processSendfile(SendfileDataBase var1);

    public abstract void doClientAuth(SSLSupport var1) throws IOException;

    public abstract SSLSupport getSslSupport(String var1);

    public boolean hasAsyncIO() {
        return false;
    }

    public boolean isReadPending() {
        return false;
    }

    public boolean isWritePending() {
        return false;
    }

    @Deprecated
    public boolean awaitReadComplete(long timeout, TimeUnit unit) {
        return true;
    }

    @Deprecated
    public boolean awaitWriteComplete(long timeout, TimeUnit unit) {
        return true;
    }

    public final <A> CompletionState read(long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler, ByteBuffer ... dsts) {
        if (dsts == null) {
            throw new IllegalArgumentException();
        }
        return this.read(dsts, 0, dsts.length, BlockingMode.CLASSIC, timeout, unit, attachment, null, handler);
    }

    public final <A> CompletionState read(BlockingMode block, long timeout, TimeUnit unit, A attachment, CompletionCheck check, CompletionHandler<Long, ? super A> handler, ByteBuffer ... dsts) {
        if (dsts == null) {
            throw new IllegalArgumentException();
        }
        return this.read(dsts, 0, dsts.length, block, timeout, unit, attachment, check, handler);
    }

    public <A> CompletionState read(ByteBuffer[] dsts, int offset, int length, BlockingMode block, long timeout, TimeUnit unit, A attachment, CompletionCheck check, CompletionHandler<Long, ? super A> handler) {
        throw new UnsupportedOperationException();
    }

    public final <A> CompletionState write(long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler, ByteBuffer ... srcs) {
        if (srcs == null) {
            throw new IllegalArgumentException();
        }
        return this.write(srcs, 0, srcs.length, BlockingMode.CLASSIC, timeout, unit, attachment, null, handler);
    }

    public final <A> CompletionState write(BlockingMode block, long timeout, TimeUnit unit, A attachment, CompletionCheck check, CompletionHandler<Long, ? super A> handler, ByteBuffer ... srcs) {
        if (srcs == null) {
            throw new IllegalArgumentException();
        }
        return this.write(srcs, 0, srcs.length, block, timeout, unit, attachment, check, handler);
    }

    public <A> CompletionState write(ByteBuffer[] srcs, int offset, int length, BlockingMode block, long timeout, TimeUnit unit, A attachment, CompletionCheck check, CompletionHandler<Long, ? super A> handler) {
        throw new UnsupportedOperationException();
    }

    protected static int transfer(byte[] from, int offset, int length, ByteBuffer to) {
        int max = Math.min(length, to.remaining());
        if (max > 0) {
            to.put(from, offset, max);
        }
        return max;
    }

    protected static int transfer(ByteBuffer from, ByteBuffer to) {
        int max = Math.min(from.remaining(), to.remaining());
        if (max > 0) {
            int fromLimit = from.limit();
            from.limit(from.position() + max);
            to.put(from);
            from.limit(fromLimit);
        }
        return max;
    }

    public static interface CompletionCheck {
        public CompletionHandlerCall callHandler(CompletionState var1, ByteBuffer[] var2, int var3, int var4);
    }

    public static enum CompletionHandlerCall {
        CONTINUE,
        NONE,
        DONE;

    }

    public static enum CompletionState {
        PENDING,
        NOT_DONE,
        INLINE,
        ERROR,
        DONE;

    }

    public static enum BlockingMode {
        CLASSIC,
        NON_BLOCK,
        SEMI_BLOCK,
        BLOCK;

    }
}

