/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol;

import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.EmptyConvertor;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class RedisCommand<R> {
    private ValueType outParamType = ValueType.OBJECT;
    private final String name;
    private final String subName;
    private MultiDecoder<R> replayMultiDecoder;
    private Decoder<R> replayDecoder;
    Convertor<R> convertor = new EmptyConvertor();

    public RedisCommand(RedisCommand<R> command, String name) {
        this.outParamType = command.outParamType;
        this.name = name;
        this.subName = command.subName;
        this.replayMultiDecoder = command.replayMultiDecoder;
        this.replayDecoder = command.replayDecoder;
        this.convertor = command.convertor;
    }

    public RedisCommand(RedisCommand<R> command, String name, Convertor<R> convertor) {
        this.outParamType = command.outParamType;
        this.name = name;
        this.subName = command.subName;
        this.replayMultiDecoder = command.replayMultiDecoder;
        this.replayDecoder = command.replayDecoder;
        this.convertor = convertor;
    }

    public RedisCommand(String name) {
        this(name, (String)null);
    }

    public RedisCommand(String name, ValueType outParamType) {
        this(name, (String)null);
        this.outParamType = outParamType;
    }

    public RedisCommand(String name, ValueType outParamType, Convertor<R> convertor) {
        this(name, (String)null);
        this.outParamType = outParamType;
        this.convertor = convertor;
    }

    public RedisCommand(String name, String subName) {
        this(name, subName, null, null);
    }

    public RedisCommand(String name, String subName, Convertor<R> convertor) {
        this(name, subName, null, null);
        this.convertor = convertor;
    }

    public RedisCommand(String name, Convertor<R> convertor) {
        this(name, null, null, null);
        this.convertor = convertor;
    }

    public RedisCommand(String name, Decoder<R> reponseDecoder) {
        this(name, null, null, reponseDecoder);
    }

    public RedisCommand(String name, String subName, MultiDecoder<R> replayMultiDecoder) {
        this(name, subName, replayMultiDecoder, null);
    }

    public RedisCommand(String name, MultiDecoder<R> replayMultiDecoder, ValueType outParamType) {
        this(name, null, replayMultiDecoder);
        this.outParamType = outParamType;
    }

    public RedisCommand(String name, MultiDecoder<R> replayMultiDecoder) {
        this(name, null, replayMultiDecoder);
    }

    public RedisCommand(String name, MultiDecoder<R> replayMultiDecoder, Convertor<R> convertor) {
        this(name, replayMultiDecoder);
        this.convertor = convertor;
    }

    RedisCommand(String name, String subName, MultiDecoder<R> replayMultiDecoder, Decoder<R> reponseDecoder) {
        this.name = name;
        this.subName = subName;
        this.replayMultiDecoder = replayMultiDecoder;
        this.replayDecoder = reponseDecoder;
    }

    public String getSubName() {
        return this.subName;
    }

    public String getName() {
        return this.name;
    }

    public Decoder<R> getReplayDecoder() {
        return this.replayDecoder;
    }

    public MultiDecoder<R> getReplayMultiDecoder() {
        return this.replayMultiDecoder;
    }

    public Convertor<R> getConvertor() {
        return this.convertor;
    }

    public ValueType getOutParamType() {
        return this.outParamType;
    }

    public String toString() {
        return "(" + this.name + (this.subName != null ? " " + this.subName : "") + ")";
    }

    public static enum ValueType {
        OBJECT,
        MAP_VALUE,
        MAP_KEY,
        MAP;

    }
}

