/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.net.URI;
import org.redisson.config.SslProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BaseConfig<T extends BaseConfig<T>> {
    private static final Logger log = LoggerFactory.getLogger("config");
    private int idleConnectionTimeout = 10000;
    private int pingTimeout = 1000;
    private int connectTimeout = 10000;
    private int timeout = 3000;
    private int retryAttempts = 3;
    private int retryInterval = 1500;
    private String password;
    private int subscriptionsPerConnection = 5;
    private String clientName;
    private boolean sslEnableEndpointIdentification = true;
    private SslProvider sslProvider = SslProvider.JDK;
    private URI sslTruststore;
    private String sslTruststorePassword;
    private URI sslKeystore;
    private String sslKeystorePassword;
    private int pingConnectionInterval;
    private boolean keepAlive;
    private boolean tcpNoDelay;

    BaseConfig() {
    }

    BaseConfig(T config) {
        this.setPassword(((BaseConfig)config).getPassword());
        this.setSubscriptionsPerConnection(((BaseConfig)config).getSubscriptionsPerConnection());
        this.setRetryAttempts(((BaseConfig)config).getRetryAttempts());
        this.setRetryInterval(((BaseConfig)config).getRetryInterval());
        this.setTimeout(((BaseConfig)config).getTimeout());
        this.setClientName(((BaseConfig)config).getClientName());
        this.setPingTimeout(((BaseConfig)config).getPingTimeout());
        this.setConnectTimeout(((BaseConfig)config).getConnectTimeout());
        this.setIdleConnectionTimeout(((BaseConfig)config).getIdleConnectionTimeout());
        this.setSslEnableEndpointIdentification(((BaseConfig)config).isSslEnableEndpointIdentification());
        this.setSslProvider(((BaseConfig)config).getSslProvider());
        this.setSslTruststore(((BaseConfig)config).getSslTruststore());
        this.setSslTruststorePassword(((BaseConfig)config).getSslTruststorePassword());
        this.setSslKeystore(((BaseConfig)config).getSslKeystore());
        this.setSslKeystorePassword(((BaseConfig)config).getSslKeystorePassword());
        this.setPingConnectionInterval(((BaseConfig)config).getPingConnectionInterval());
        this.setKeepAlive(((BaseConfig)config).isKeepAlive());
        this.setTcpNoDelay(((BaseConfig)config).isTcpNoDelay());
    }

    public T setSubscriptionsPerConnection(int subscriptionsPerConnection) {
        this.subscriptionsPerConnection = subscriptionsPerConnection;
        return (T)this;
    }

    public int getSubscriptionsPerConnection() {
        return this.subscriptionsPerConnection;
    }

    public T setPassword(String password) {
        this.password = password;
        return (T)this;
    }

    public String getPassword() {
        return this.password;
    }

    public T setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
        return (T)this;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public T setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
        return (T)this;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public T setTimeout(int timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public T setClientName(String clientName) {
        this.clientName = clientName;
        return (T)this;
    }

    public String getClientName() {
        return this.clientName;
    }

    @Deprecated
    public T setPingTimeout(int pingTimeout) {
        this.pingTimeout = pingTimeout;
        return (T)this;
    }

    public int getPingTimeout() {
        return this.pingTimeout;
    }

    public T setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return (T)this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public T setIdleConnectionTimeout(int idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
        return (T)this;
    }

    public int getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    @Deprecated
    public T setReconnectionTimeout(int slaveRetryTimeout) {
        log.warn("'reconnectionTimeout' setting in unavailable. Please use 'failedSlaveReconnectionInterval' setting instead!");
        return (T)this;
    }

    @Deprecated
    public T setFailedAttempts(int slaveFailedAttempts) {
        log.warn("'failedAttempts' setting in unavailable. Please use 'failedSlaveCheckInterval' setting instead!");
        return (T)this;
    }

    public boolean isSslEnableEndpointIdentification() {
        return this.sslEnableEndpointIdentification;
    }

    public T setSslEnableEndpointIdentification(boolean sslEnableEndpointIdentification) {
        this.sslEnableEndpointIdentification = sslEnableEndpointIdentification;
        return (T)this;
    }

    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    public T setSslProvider(SslProvider sslProvider) {
        this.sslProvider = sslProvider;
        return (T)this;
    }

    public URI getSslTruststore() {
        return this.sslTruststore;
    }

    public T setSslTruststore(URI sslTruststore) {
        this.sslTruststore = sslTruststore;
        return (T)this;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public T setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
        return (T)this;
    }

    public URI getSslKeystore() {
        return this.sslKeystore;
    }

    public T setSslKeystore(URI sslKeystore) {
        this.sslKeystore = sslKeystore;
        return (T)this;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public T setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
        return (T)this;
    }

    public int getPingConnectionInterval() {
        return this.pingConnectionInterval;
    }

    public T setPingConnectionInterval(int pingConnectionInterval) {
        this.pingConnectionInterval = pingConnectionInterval;
        return (T)this;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public T setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return (T)this;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public T setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return (T)this;
    }
}

