/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import io.netty.util.internal.PlatformDependent;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.executor.TasksService;
import org.redisson.executor.params.ScheduledParameters;
import org.redisson.misc.RPromise;
import org.redisson.remote.RRemoteServiceResponse;
import org.redisson.remote.RemoteServiceRequest;
import org.redisson.remote.RequestId;
import org.redisson.remote.ResponseEntry;

public class ScheduledTasksService
extends TasksService {
    private RequestId requestId;

    public ScheduledTasksService(Codec codec, RedissonClient redisson, String name, CommandExecutor commandExecutor, String redissonId, ConcurrentMap<String, ResponseEntry> responses) {
        super(codec, redisson, name, commandExecutor, redissonId, responses);
    }

    public void setRequestId(RequestId requestId) {
        this.requestId = requestId;
    }

    @Override
    protected RFuture<Boolean> addAsync(String requestQueueName, RemoteServiceRequest request) {
        ScheduledParameters params = (ScheduledParameters)request.getArgs()[0];
        params.setRequestId(request.getId());
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[2]) == 0 then local retryInterval = redis.call('get', KEYS[6]); if retryInterval ~= false then local time = tonumber(ARGV[1]) + tonumber(retryInterval);redis.call('zadd', KEYS[3], time, 'ff' .. ARGV[2]);elseif tonumber(ARGV[4]) > 0 then redis.call('set', KEYS[6], ARGV[4]);local time = tonumber(ARGV[1]) + tonumber(ARGV[4]);redis.call('zadd', KEYS[3], time, 'ff' .. ARGV[2]);end; redis.call('zadd', KEYS[3], ARGV[1], ARGV[2]);redis.call('hset', KEYS[5], ARGV[2], ARGV[3]);redis.call('incr', KEYS[1]);local v = redis.call('zrange', KEYS[3], 0, 0); if v[1] == ARGV[2] then redis.call('publish', KEYS[4], ARGV[1]); end return 1;end;return 0;", Arrays.asList(this.tasksCounterName, this.statusName, this.schedulerQueueName, this.schedulerChannelName, this.tasksName, this.tasksRetryIntervalName), params.getStartTime(), request.getId(), this.encode(request), this.tasksRetryInterval);
    }

    @Override
    protected RFuture<Boolean> removeAsync(String requestQueueName, RequestId taskId) {
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[3]) == 0 then return 1;end;local task = redis.call('hget', KEYS[6], ARGV[1]); redis.call('hdel', KEYS[6], ARGV[1]); redis.call('zrem', KEYS[2], 'ff' .. ARGV[1]); local removedScheduled = redis.call('zrem', KEYS[2], ARGV[1]); local removed = redis.call('lrem', KEYS[1], 1, ARGV[1]); if task ~= false and (removed > 0 or removedScheduled > 0) then if redis.call('decr', KEYS[3]) == 0 then redis.call('del', KEYS[3]);if redis.call('get', KEYS[4]) == ARGV[2] then redis.call('del', KEYS[7]);redis.call('set', KEYS[4], ARGV[3]);redis.call('publish', KEYS[5], ARGV[3]);end;end;return 1;end;if task == false then return 1; end;return 0;", Arrays.asList(requestQueueName, this.schedulerQueueName, this.tasksCounterName, this.statusName, this.terminationTopicName, this.tasksName, this.tasksRetryIntervalName), taskId.toString(), 1, 2);
    }

    @Override
    protected <T extends RRemoteServiceResponse> RPromise<T> pollResultResponse(long timeout, RequestId requestId, RemoteServiceRequest request) {
        if (request.getArgs()[0].getClass() == ScheduledParameters.class) {
            ScheduledParameters params = (ScheduledParameters)request.getArgs()[0];
            timeout += params.getStartTime() - System.currentTimeMillis();
        }
        return super.pollResultResponse(timeout, requestId, request);
    }

    @Override
    protected RequestId generateRequestId() {
        if (this.requestId == null) {
            byte[] id = new byte[17];
            PlatformDependent.threadLocalRandom().nextBytes(id);
            id[0] = 1;
            return new RequestId(id);
        }
        return this.requestId;
    }
}

