/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.mapreduce;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.redisson.Redisson;
import org.redisson.api.RExecutorFuture;
import org.redisson.api.RScheduledExecutorService;
import org.redisson.api.RedissonClient;
import org.redisson.api.annotation.RInject;
import org.redisson.api.mapreduce.RCollator;
import org.redisson.api.mapreduce.RReducer;
import org.redisson.client.codec.Codec;
import org.redisson.mapreduce.BaseMapperTask;
import org.redisson.mapreduce.CollatorTask;
import org.redisson.mapreduce.MapReduceTimeoutException;
import org.redisson.mapreduce.ReducerTask;
import org.redisson.mapreduce.SubTasksExecutor;

public class CoordinatorTask<KOut, VOut>
implements Callable<Object>,
Serializable {
    private static final long serialVersionUID = 7559371478909848610L;
    @RInject
    protected RedissonClient redisson;
    private BaseMapperTask<KOut, VOut> mapperTask;
    private RCollator<KOut, VOut, Object> collator;
    private RReducer<KOut, VOut> reducer;
    protected String objectName;
    protected Class<?> objectClass;
    private Class<?> objectCodecClass;
    private String resultMapName;
    private long timeout;
    private long startTime;
    protected Codec codec;

    public CoordinatorTask() {
    }

    public CoordinatorTask(BaseMapperTask<KOut, VOut> mapperTask, RReducer<KOut, VOut> reducer, String mapName, String resultMapName, Class<?> mapCodecClass, Class<?> objectClass, RCollator<KOut, VOut, Object> collator, long timeout, long startTime) {
        this.mapperTask = mapperTask;
        this.reducer = reducer;
        this.objectName = mapName;
        this.objectCodecClass = mapCodecClass;
        this.objectClass = objectClass;
        this.resultMapName = resultMapName;
        this.collator = collator;
        this.timeout = timeout;
        this.startTime = startTime;
    }

    @Override
    public Object call() throws Exception {
        long timeSpent = System.currentTimeMillis() - this.startTime;
        if (this.isTimeoutExpired(timeSpent)) {
            throw new MapReduceTimeoutException();
        }
        this.codec = (Codec)this.objectCodecClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        RScheduledExecutorService executor = this.redisson.getExecutorService("redisson_mapreduce");
        int workersAmount = executor.countActiveWorkers();
        UUID id = UUID.randomUUID();
        String collectorMapName = this.objectName + ":collector:" + id;
        this.mapperTask.setCollectorMapName(collectorMapName);
        this.mapperTask.setWorkersAmount(workersAmount);
        timeSpent = System.currentTimeMillis() - this.startTime;
        if (this.isTimeoutExpired(timeSpent)) {
            throw new MapReduceTimeoutException();
        }
        if (this.timeout > 0L) {
            this.mapperTask.setTimeout(this.timeout - timeSpent);
        }
        this.mapperTask.addObjectName(this.objectName);
        RExecutorFuture<?> mapperFuture = executor.submitAsync((Runnable)this.mapperTask);
        try {
            if (this.timeout > 0L && !mapperFuture.await(this.timeout - timeSpent)) {
                mapperFuture.cancel(true);
                throw new MapReduceTimeoutException();
            }
            if (this.timeout == 0L) {
                mapperFuture.await();
            }
        }
        catch (InterruptedException e) {
            mapperFuture.cancel(true);
            return null;
        }
        SubTasksExecutor reduceExecutor = new SubTasksExecutor(executor, workersAmount, this.startTime, this.timeout);
        for (int i = 0; i < workersAmount; ++i) {
            String name = collectorMapName + ":" + i;
            ReducerTask<KOut, VOut> runnable = new ReducerTask<KOut, VOut>(name, this.reducer, this.objectCodecClass, this.resultMapName, this.timeout - timeSpent);
            reduceExecutor.submit(runnable);
        }
        if (!reduceExecutor.await()) {
            return null;
        }
        return this.executeCollator();
    }

    private Object executeCollator() throws ExecutionException, Exception {
        if (this.collator == null) {
            if (this.timeout > 0L) {
                this.redisson.getMap(this.resultMapName).clearExpire();
            }
            return null;
        }
        CollatorTask<KOut, VOut, Object> collatorTask = new CollatorTask<KOut, VOut, Object>(this.redisson, this.collator, this.resultMapName, this.objectCodecClass);
        long timeSpent = System.currentTimeMillis() - this.startTime;
        if (this.isTimeoutExpired(timeSpent)) {
            throw new MapReduceTimeoutException();
        }
        if (this.timeout > 0L) {
            ExecutorService executor = ((Redisson)this.redisson).getConnectionManager().getExecutor();
            Future collatorFuture = executor.submit(collatorTask);
            try {
                return collatorFuture.get(this.timeout - timeSpent, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (TimeoutException e) {
                collatorFuture.cancel(true);
                throw new MapReduceTimeoutException();
            }
        }
        return collatorTask.call();
    }

    private boolean isTimeoutExpired(long timeSpent) {
        return timeSpent > this.timeout && this.timeout > 0L;
    }
}

