/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.reactivex.Flowable;
import io.reactivex.functions.LongConsumer;
import io.reactivex.processors.ReplayProcessor;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import org.redisson.RedissonKeys;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.rx.CommandRxExecutor;

public class RedissonKeysRx {
    private final CommandRxExecutor commandExecutor;
    private final RedissonKeys instance;

    public RedissonKeysRx(CommandRxExecutor commandExecutor) {
        this.instance = new RedissonKeys(commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    public Flowable<String> getKeysByPattern(String pattern) {
        return this.getKeysByPattern(pattern, 10);
    }

    public Flowable<String> getKeysByPattern(String pattern, int count) {
        ArrayList<Publisher<String>> publishers = new ArrayList<Publisher<String>>();
        for (MasterSlaveEntry entry : this.commandExecutor.getConnectionManager().getEntrySet()) {
            publishers.add(this.createKeysIterator(entry, pattern, count));
        }
        return Flowable.merge(publishers);
    }

    private Publisher<String> createKeysIterator(final MasterSlaveEntry entry, final String pattern, final int count) {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){
            private RedisClient client;
            private List<String> firstValues;
            private long nextIterPos;
            private long currentIndex;

            @Override
            public void accept(long value) {
                this.currentIndex = value;
                this.nextValues();
            }

            protected void nextValues() {
                RedissonKeysRx.this.instance.scanIteratorAsync(this.client, entry, this.nextIterPos, pattern, count).addListener(new FutureListener<ListScanResult<Object>>(){

                    @Override
                    public void operationComplete(Future<ListScanResult<Object>> future) throws Exception {
                        if (!future.isSuccess()) {
                            p.onError(future.cause());
                            return;
                        }
                        ListScanResult res = (ListScanResult)future.get();
                        client = res.getRedisClient();
                        long prevIterPos = nextIterPos;
                        if (nextIterPos == 0L && firstValues == null) {
                            firstValues = (List)res.getValues();
                        } else if (res.getValues().equals(firstValues)) {
                            p.onComplete();
                            currentIndex = 0L;
                            return;
                        }
                        nextIterPos = res.getPos();
                        if (prevIterPos == nextIterPos) {
                            nextIterPos = -1L;
                        }
                        for (Object val : res.getValues()) {
                            p.onNext((String)val);
                            currentIndex--;
                            if (currentIndex != 0L) continue;
                            p.onComplete();
                            return;
                        }
                        if (nextIterPos == -1L) {
                            p.onComplete();
                            currentIndex = 0L;
                        }
                        if (currentIndex == 0L) {
                            return;
                        }
                        this.nextValues();
                    }
                });
            }
        });
    }
}

