/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.Flowable;
import java.util.concurrent.Callable;
import org.redisson.api.RBucketRx;
import org.redisson.api.RFuture;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RMapCacheRx;
import org.redisson.api.RMapRx;
import org.redisson.api.RSet;
import org.redisson.api.RSetCache;
import org.redisson.api.RSetCacheRx;
import org.redisson.api.RSetRx;
import org.redisson.api.RTransaction;
import org.redisson.api.RTransactionRx;
import org.redisson.api.TransactionOptions;
import org.redisson.client.codec.Codec;
import org.redisson.reactive.RedissonSetReactive;
import org.redisson.rx.CommandRxExecutor;
import org.redisson.rx.RedissonMapCacheRx;
import org.redisson.rx.RedissonMapRx;
import org.redisson.rx.RedissonSetCacheRx;
import org.redisson.rx.RedissonSetRx;
import org.redisson.rx.RxProxyBuilder;
import org.redisson.transaction.RedissonTransaction;

public class RedissonTransactionRx
implements RTransactionRx {
    private final RTransaction transaction;
    private final CommandRxExecutor executorService;

    public RedissonTransactionRx(CommandRxExecutor executorService, TransactionOptions options) {
        this.transaction = new RedissonTransaction(executorService, options);
        this.executorService = executorService;
    }

    @Override
    public <V> RBucketRx<V> getBucket(String name) {
        return RxProxyBuilder.create(this.executorService, this.transaction.getBucket(name), RBucketRx.class);
    }

    @Override
    public <V> RBucketRx<V> getBucket(String name, Codec codec) {
        return RxProxyBuilder.create(this.executorService, this.transaction.getBucket(name, codec), RBucketRx.class);
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(String name) {
        RMap map = this.transaction.getMap(name);
        return RxProxyBuilder.create(this.executorService, map, new RedissonMapRx(map, null), RMapRx.class);
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(String name, Codec codec) {
        RMap map = this.transaction.getMap(name, codec);
        return RxProxyBuilder.create(this.executorService, map, new RedissonMapRx(map, null), RMapRx.class);
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(String name, Codec codec) {
        RMapCache map = this.transaction.getMapCache(name, codec);
        return RxProxyBuilder.create(this.executorService, map, new RedissonMapCacheRx(map), RMapCacheRx.class);
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(String name) {
        RMapCache map = this.transaction.getMapCache(name);
        return RxProxyBuilder.create(this.executorService, map, new RedissonMapCacheRx(map), RMapCacheRx.class);
    }

    @Override
    public <V> RSetRx<V> getSet(String name) {
        RSet set = this.transaction.getSet(name);
        return RxProxyBuilder.create(this.executorService, set, new RedissonSetReactive(set, null), RSetRx.class);
    }

    @Override
    public <V> RSetRx<V> getSet(String name, Codec codec) {
        RSet set = this.transaction.getSet(name, codec);
        return RxProxyBuilder.create(this.executorService, set, new RedissonSetRx(set, null), RSetRx.class);
    }

    @Override
    public <V> RSetCacheRx<V> getSetCache(String name) {
        RSetCache set = this.transaction.getSetCache(name);
        return RxProxyBuilder.create(this.executorService, set, new RedissonSetCacheRx(set, null), RSetCacheRx.class);
    }

    @Override
    public <V> RSetCacheRx<V> getSetCache(String name, Codec codec) {
        RSetCache set = this.transaction.getSetCache(name, codec);
        return RxProxyBuilder.create(this.executorService, set, new RedissonSetCacheRx(set, null), RSetCacheRx.class);
    }

    @Override
    public Flowable<Void> commit() {
        return this.executorService.flowable(new Callable<RFuture<Void>>(){

            @Override
            public RFuture<Void> call() {
                return RedissonTransactionRx.this.transaction.commitAsync();
            }
        });
    }

    @Override
    public Flowable<Void> rollback() {
        return this.executorService.flowable(new Callable<RFuture<Void>>(){

            @Override
            public RFuture<Void> call() {
                return RedissonTransactionRx.this.transaction.rollbackAsync();
            }
        });
    }
}

